/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.mobile.fcm.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.Reader;

/**
 * @author Bruno Farache
 */
public abstract class Json {

	public static <T> T fromJson(Reader reader, Class<T> clazz) {
		return gson().fromJson(reader, clazz);
	}

	public static String toJson(Object object) {
		return gson().toJson(object);
	}

	protected static GsonBuilder createDefaultGsonBuilder() {
		return new GsonBuilder().disableHtmlEscaping();
	}

	protected static Gson gson() {
		if (gson == null) {
			gson = createDefaultGsonBuilder()
				.create();
		}

		return gson;
	}

	protected static Gson gson;

}