/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.mobile.fcm;

import com.liferay.mobile.fcm.json.Response;

import io.reactivex.Single;

/**
 * @author Bruno Farache
 */

public class RxSender {

	public RxSender(String key) {
		this(new Sender(key));
	}

	public RxSender(Sender sender) {
		findRxInClasspath("io.reactivex.Single");
		this.sender = sender;
	}

	public Single<Status> send(Message message) {
		return Single.fromCallable(() ->
			sender.send(message)
		);
	}

	public Sender sender() {
		return sender;
	}

	protected static void findRxInClasspath(String className) {
		try {
			Class.forName(className);
		}
		catch (ClassNotFoundException cnfe) {
			throw new RuntimeException(
				"RxSender needs RxJava 2.0.x added as runtime dependency",
				cnfe);
		}
	}

	protected final Sender sender;

}