/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
package com.liferay.mobile.fcm;

/**
 * @author Bruno Farache
 */
public class MessageResult {

	public String error() {
		return error;
	}

	public String messageId() {
		return messageId;
	}

	public String newToken() {
		return newToken;
	}

	public String token() {
		return token;
	}

	public static class Builder {

		public Builder error(String error) {
			this.error = error;
			return this;
		}

		public Builder messageId(String messageId) {
			this.messageId = messageId;
			return this;
		}

		public Builder newToken(String newToken) {
			this.newToken = newToken;
			return this;
		}

		public Builder token(String token) {
			this.token = token;
			return this;
		}

		public MessageResult build() {
			return new MessageResult(this);
		}

		String error;
		String messageId;
		String newToken;
		String token;

	}

	protected MessageResult(Builder builder) {
		this.error = builder.error;
		this.messageId = builder.messageId;
		this.newToken = builder.newToken;
		this.token = builder.token;
	}

	protected final String error;
	protected final String messageId;
	protected final String newToken;
	protected final String token;

}