/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.archetype.source.CatalogArchetypeDataSource;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.ReaderFactory;

@Component(role=ArchetypeDataSource.class, hint="remote-catalog")
public class RemoteCatalogArchetypeDataSource
extends CatalogArchetypeDataSource {
    @Requirement
    private WagonManager wagonManager;
    public static final String REPOSITORY_PROPERTY = "repository";
    public static final String REPOSITORY_ID = "archetype";

    public ArchetypeCatalog getArchetypeCatalog(Properties properties) throws ArchetypeDataSourceException {
        String repository = properties.getProperty(REPOSITORY_PROPERTY);
        if (repository == null) {
            throw new ArchetypeDataSourceException("To use the remote catalog you must specify the 'repository' property with an URL.");
        }
        if (repository.endsWith("/")) {
            repository = repository.substring(0, repository.length() - 1);
        }
        try {
            return this.downloadCatalog(repository, "archetype-catalog.xml");
        }
        catch (ArchetypeDataSourceException e) {
            throw e;
        }
        catch (Exception e) {
            String repositoryPath = repository.substring(0, repository.lastIndexOf("/"));
            String filename = repository.substring(repository.lastIndexOf("/") + 1);
            try {
                return this.downloadCatalog(repositoryPath, filename);
            }
            catch (Exception ex) {
                this.getLogger().warn("Error reading archetype catalog " + repository, ex);
                return new ArchetypeCatalog();
            }
        }
    }

    public void updateCatalog(Properties properties, Archetype archetype) throws ArchetypeDataSourceException {
        throw new ArchetypeDataSourceException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchetypeCatalog downloadCatalog(String repositoryPath, String filename) throws WagonException, IOException, ArchetypeDataSourceException {
        this.getLogger().debug("Searching for remote catalog: " + repositoryPath + "/" + filename);
        Repository wagonRepository = new Repository(REPOSITORY_ID, repositoryPath);
        AuthenticationInfo authInfo = this.wagonManager.getAuthenticationInfo(wagonRepository.getId());
        ProxyInfo proxyInfo = this.wagonManager.getProxy(wagonRepository.getProtocol());
        Wagon wagon = this.wagonManager.getWagon(wagonRepository);
        File catalog = File.createTempFile("archetype-catalog", ".xml");
        try {
            wagon.connect(wagonRepository, authInfo, proxyInfo);
            wagon.get(filename, catalog);
            ArchetypeCatalog archetypeCatalog = this.readCatalog(ReaderFactory.newXmlReader(catalog));
            return archetypeCatalog;
        }
        finally {
            this.disconnectWagon(wagon);
            catalog.delete();
        }
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            wagon.disconnect();
        }
        catch (Exception e) {
            this.getLogger().warn("Problem disconnecting from wagon - ignoring: " + e.getMessage());
        }
    }
}

