/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.archetype.common.ArchetypeRegistryManager;
import org.apache.maven.archetype.common.Constants;
import org.apache.maven.archetype.registry.ArchetypeRegistry;
import org.apache.maven.archetype.registry.io.xpp3.ArchetypeRegistryXpp3Reader;
import org.apache.maven.archetype.registry.io.xpp3.ArchetypeRegistryXpp3Writer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArchetypeRegistryManager.class)
public class DefaultArchetypeRegistryManager
extends AbstractLogEnabled
implements ArchetypeRegistryManager {
    @Requirement
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Requirement
    private ArtifactRepositoryLayout defaultArtifactRepositoryLayout;

    @Override
    public List<String> getFilteredExtensions(String archetypeFilteredExtentions, File archetypeRegistryFile) throws IOException {
        ArrayList<String> filteredExtensions = new ArrayList<String>();
        if (StringUtils.isNotEmpty(archetypeFilteredExtentions)) {
            filteredExtensions.addAll(Arrays.asList(StringUtils.split(archetypeFilteredExtentions, ",")));
        }
        try {
            ArchetypeRegistry registry = this.readArchetypeRegistry(archetypeRegistryFile);
            filteredExtensions.addAll(registry.getFilteredExtensions());
        }
        catch (IOException e) {
            this.getLogger().warn("Cannot read ~/.m2/archetype.xml");
        }
        catch (XmlPullParserException e) {
            this.getLogger().warn("Cannot read ~/.m2/archetype.xml");
        }
        if (filteredExtensions.isEmpty()) {
            filteredExtensions.addAll(Constants.DEFAULT_FILTERED_EXTENSIONS);
        }
        return filteredExtensions;
    }

    @Override
    public List<String> getLanguages(String archetypeLanguages, File archetypeRegistryFile) throws IOException {
        ArrayList<String> languages = new ArrayList<String>();
        if (StringUtils.isNotEmpty(archetypeLanguages)) {
            languages.addAll(Arrays.asList(StringUtils.split(archetypeLanguages, ",")));
        }
        try {
            ArchetypeRegistry registry = this.readArchetypeRegistry(archetypeRegistryFile);
            languages.addAll(registry.getLanguages());
        }
        catch (IOException e) {
            this.getLogger().warn("Can not read ~/.m2/archetype.xml");
        }
        catch (XmlPullParserException e) {
            this.getLogger().warn("Can not read ~/.m2/archetype.xml");
        }
        if (languages.isEmpty()) {
            languages.addAll(Constants.DEFAULT_LANGUAGES);
        }
        return languages;
    }

    @Override
    public ArchetypeRegistry readArchetypeRegistry(File archetypeRegistryFile) throws IOException, XmlPullParserException {
        if (!archetypeRegistryFile.exists()) {
            return this.getDefaultArchetypeRegistry();
        }
        return this.readArchetypeRegistry(ReaderFactory.newXmlReader(archetypeRegistryFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArchetypeRegistry readArchetypeRegistry(Reader reader) throws IOException, XmlPullParserException {
        ArchetypeRegistryXpp3Reader xpp3Reader = new ArchetypeRegistryXpp3Reader();
        try {
            ArchetypeRegistry archetypeRegistry = xpp3Reader.read(reader);
            return archetypeRegistry;
        }
        finally {
            IOUtil.close(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeArchetypeRegistry(File archetypeRegistryFile, ArchetypeRegistry archetypeRegistry) throws IOException {
        ArchetypeRegistryXpp3Writer writer = new ArchetypeRegistryXpp3Writer();
        XmlStreamWriter out = WriterFactory.newXmlWriter(archetypeRegistryFile);
        try {
            writer.write((Writer)out, archetypeRegistry);
        }
        finally {
            IOUtil.close(out);
        }
    }

    @Override
    public ArtifactRepository createRepository(String url, String repositoryId) {
        String updatePolicyFlag = "always";
        String checksumPolicyFlag = "warn";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        return this.artifactRepositoryFactory.createArtifactRepository(repositoryId, url, this.defaultArtifactRepositoryLayout, snapshotsPolicy, releasesPolicy);
    }

    @Override
    public ArchetypeRegistry getDefaultArchetypeRegistry() {
        ArchetypeRegistry registry = new ArchetypeRegistry();
        registry.getLanguages().addAll(Constants.DEFAULT_LANGUAGES);
        registry.getFilteredExtensions().addAll(Constants.DEFAULT_FILTERED_EXTENSIONS);
        return registry;
    }
}

