/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import java.nio.file.Files
import java.nio.file.Path
import java.nio.file.Paths

Path projectPath = Paths.get(request.outputDirectory, request.artifactId)

Path apiPath = projectPath.resolve(request.artifactId + "-api")
Path buildGradlePath = projectPath.resolve("build.gradle")
Path clientPath = projectPath.resolve(request.artifactId + "-client")
Path implementationPath = projectPath.resolve(request.artifactId + "-impl")
Path testPath = projectPath.resolve(request.artifactId + "-test")

Path apiBuildGradlePath = apiPath.resolve("build.gradle")
Path buildSettingsPath = projectPath.resolve("settings.gradle")
Path clientBuildGradlePath = clientPath.resolve("build.gradle")
Path implementationBuildGradlePath = implementationPath.resolve("build.gradle")
Path testBuildGradlePath = testPath.resolve("build.gradle")

Files.deleteIfExists apiBuildGradlePath
Files.deleteIfExists buildGradlePath
Files.deleteIfExists buildSettingsPath
Files.deleteIfExists clientBuildGradlePath
Files.deleteIfExists implementationBuildGradlePath
Files.deleteIfExists testBuildGradlePath