/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.rest.builder.internal;

import com.liferay.project.templates.extensions.ProjectTemplateCustomizer;
import com.liferay.project.templates.extensions.ProjectTemplatesArgs;
import com.liferay.project.templates.extensions.util.WorkspaceUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;

public class RESTBuilderProjectTemplateCustomizer
implements ProjectTemplateCustomizer {
    public String getTemplateName() {
        return "rest-builder";
    }

    public void onAfterGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, File destinationDir, ArchetypeGenerationResult archetypeGenerationResult) {
    }

    public void onBeforeGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, ArchetypeGenerationRequest archetypeGenerationRequest) throws Exception {
        String artifactId = archetypeGenerationRequest.getArtifactId();
        String apiPath = ":" + artifactId + "-api";
        String clientPath = ":" + artifactId + "-client";
        File destinationDir = new File(archetypeGenerationRequest.getOutputDirectory());
        File workspaceDir = WorkspaceUtil.getWorkspaceDir((File)destinationDir);
        if (workspaceDir != null) {
            Path destinationDirPath = destinationDir.toPath();
            Path workspaceDirPath = workspaceDir.toPath();
            destinationDirPath = destinationDirPath.toAbsolutePath();
            workspaceDirPath = workspaceDirPath.toAbsolutePath();
            String relativePath = String.valueOf(workspaceDirPath.relativize(destinationDirPath));
            relativePath = relativePath.replace(File.separatorChar, ':');
            apiPath = ":" + relativePath + ":" + artifactId + apiPath;
            clientPath = ":" + relativePath + ":" + artifactId + clientPath;
        }
        Properties properties = archetypeGenerationRequest.getProperties();
        this.setProperty(properties, "apiPath", apiPath);
        this.setProperty(properties, "clientPath", clientPath);
    }
}

