/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.layout.template.internal;

import com.liferay.project.templates.extensions.ProjectTemplateCustomizer;
import com.liferay.project.templates.extensions.ProjectTemplatesArgs;
import com.liferay.project.templates.extensions.util.FileUtil;
import com.liferay.project.templates.extensions.util.VersionUtil;
import java.io.File;
import java.nio.file.Path;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;

public class LayoutTemplateProjectTemplateCustomizer
implements ProjectTemplateCustomizer {
    public String getTemplateName() {
        return "layout-template";
    }

    public void onAfterGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, File destinationDir, ArchetypeGenerationResult archetypeGenerationResult) throws Exception {
        Path destinationDirPath = destinationDir.toPath();
        Path projectPath = destinationDirPath.resolve(projectTemplatesArgs.getName());
        File buildDir = projectPath.toFile();
        File webINFDir = new File(buildDir, "src/main/webapp/WEB-INF");
        String liferayVersion = projectTemplatesArgs.getLiferayVersion();
        String minorVersionString = String.valueOf(VersionUtil.getMinorVersion((String)liferayVersion));
        if (VersionUtil.isLiferayQuarterlyVersion((String)liferayVersion)) {
            minorVersionString = "4";
        }
        File liferayLayoutTemplatesXMLFile = new File(webINFDir, "liferay-layout-templates.xml");
        FileUtil.replaceString((File)liferayLayoutTemplatesXMLFile, (String)"7.0", (String)("7." + minorVersionString));
        FileUtil.replaceString((File)liferayLayoutTemplatesXMLFile, (String)"7_0", (String)("7_" + minorVersionString));
    }

    public void onBeforeGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, ArchetypeGenerationRequest archetypeGenerationRequest) throws Exception {
    }
}

