/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.extensions.util;

import com.liferay.project.templates.extensions.ProjectTemplatesArgs;
import com.liferay.project.templates.extensions.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ProjectTemplatesUtil {
    private static final Map<String, File> _archetypeFiles = new HashMap<String, File>();

    public static File getArchetypeFile(String artifactId) throws IOException {
        if (_archetypeFiles.containsKey(artifactId)) {
            return _archetypeFiles.get(artifactId);
        }
        Properties projectTemplateJarVersionsProperties = ProjectTemplatesUtil.getProjectTemplateJarVersionsProperties();
        if (!projectTemplateJarVersionsProperties.containsKey(artifactId)) {
            return null;
        }
        String version = String.valueOf(projectTemplateJarVersionsProperties.get(artifactId));
        try {
            String jarName = ProjectTemplatesUtil.getArchetypeJarName(artifactId, version);
            InputStream inputStream = ProjectTemplatesUtil.class.getResourceAsStream(jarName);
            Path archetypePath = Files.createTempFile("temp-archetype", null, new FileAttribute[0]);
            Files.copy(inputStream, archetypePath, StandardCopyOption.REPLACE_EXISTING);
            File archetypeFile = archetypePath.toFile();
            _archetypeFiles.put(artifactId, archetypeFile);
            archetypeFile.deleteOnExit();
            return archetypeFile;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static File getArchetypeFile(String artifactId, File file) throws IOException {
        File archetypeFile = ProjectTemplatesUtil.getArchetypeFile(artifactId);
        if (archetypeFile != null) {
            return archetypeFile;
        }
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String name;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !(name = jarEntry.getName()).startsWith(artifactId + "-")) continue;
                Path archetypePath = Files.createTempFile("temp-archetype", null, new FileAttribute[0]);
                Files.copy(jarFile.getInputStream(jarEntry), archetypePath, StandardCopyOption.REPLACE_EXISTING);
                archetypeFile = archetypePath.toFile();
                _archetypeFiles.put(artifactId, archetypeFile);
                archetypeFile.deleteOnExit();
            }
        }
        return archetypeFile;
    }

    public static String getArchetypeJarName(String artifactId, String version) {
        return "/" + artifactId + "-" + version + ".jar";
    }

    public static List<String> getArchetypeJarNames() throws IOException {
        Properties projectTemplateJarVersionsProperties = ProjectTemplatesUtil.getProjectTemplateJarVersionsProperties();
        ArrayList<String> archetypeJarNames = new ArrayList<String>();
        Set<String> artifactIds = projectTemplateJarVersionsProperties.stringPropertyNames();
        for (String artifactId : artifactIds) {
            String version = projectTemplateJarVersionsProperties.getProperty(artifactId);
            String jarName = ProjectTemplatesUtil.getArchetypeJarName(artifactId, version);
            archetypeJarNames.add(jarName);
        }
        return archetypeJarNames;
    }

    public static String getArchetypeVersion(String artifactId) throws IOException {
        Properties projectTemplateJarVersionsProperties = ProjectTemplatesUtil.getProjectTemplateJarVersionsProperties();
        return projectTemplateJarVersionsProperties.getProperty(artifactId);
    }

    public static Properties getProjectTemplateJarVersionsProperties() throws IOException {
        Properties projectTemplateJarVersionsProperties = new Properties();
        try (InputStream inputStream = ProjectTemplatesUtil.class.getResourceAsStream("/project-template-jar-versions.properties");){
            projectTemplateJarVersionsProperties.load(inputStream);
        }
        return projectTemplateJarVersionsProperties;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getTemplateFile(ProjectTemplatesArgs projectTemplatesArgs) throws Exception {
        Throwable throwable;
        DirectoryStream<Path> directoryStream;
        String template = projectTemplatesArgs.getTemplate();
        String templateVersion = projectTemplatesArgs.getTemplateVersion();
        Iterator<File> iterator = projectTemplatesArgs.getArchetypesDirs().iterator();
        while (true) {
            block24: {
                if (!iterator.hasNext()) {
                    String artifactId = "com.liferay.project.templates." + template.replace('-', '.');
                    return ProjectTemplatesUtil.getArchetypeFile(artifactId);
                }
                File archetypesDir = iterator.next();
                if (!archetypesDir.isDirectory()) continue;
                Path archetypesDirPath = archetypesDir.toPath();
                directoryStream = Files.newDirectoryStream(archetypesDirPath, "*.project.templates.*");
                throwable = null;
                for (Path path : directoryStream) {
                    block22: {
                        File file;
                        block23: {
                            File templateFile;
                            block20: {
                                File file2;
                                block21: {
                                    String bundleSymbolicName = FileUtil.getManifestProperty(path.toFile(), "Bundle-SymbolicName");
                                    String templateName = ProjectTemplatesUtil.getTemplateName(bundleSymbolicName);
                                    if (!templateName.equals(template)) continue;
                                    templateFile = path.toFile();
                                    if (templateVersion != null) break block20;
                                    file2 = templateFile;
                                    if (directoryStream == null) return file2;
                                    if (throwable == null) break block21;
                                    {
                                        catch (IOException iOException) {
                                            continue;
                                        }
                                    }
                                    try {
                                        directoryStream.close();
                                        return file2;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                        return file2;
                                    }
                                }
                                directoryStream.close();
                                return file2;
                            }
                            String bundleVersion = FileUtil.getManifestProperty(templateFile, "Bundle-Version");
                            if (!templateVersion.equals(bundleVersion)) break block22;
                            file = templateFile;
                            if (directoryStream == null) return file;
                            if (throwable == null) break block23;
                            try {
                                directoryStream.close();
                                return file;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                return file;
                            }
                        }
                        directoryStream.close();
                        return file;
                    }
                }
                if (directoryStream == null) continue;
                if (throwable == null) break block24;
                try {
                    directoryStream.close();
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                continue;
            }
            directoryStream.close();
        }
        catch (Throwable throwable5) {
            try {
                throwable = throwable5;
                throw throwable5;
            }
            catch (Throwable throwable6) {
                if (directoryStream == null) throw throwable6;
                if (throwable == null) {
                    directoryStream.close();
                    throw throwable6;
                }
                try {
                    directoryStream.close();
                    throw throwable6;
                }
                catch (Throwable throwable7) {
                    throwable.addSuppressed(throwable7);
                    throw throwable6;
                }
            }
        }
    }

    public static String getTemplateName(String name) {
        String projectTemplatesString = "project.templates.";
        try {
            if (!name.contains(projectTemplatesString)) {
                return name;
            }
            int projectTemplatesEndIndex = name.indexOf(projectTemplatesString) + projectTemplatesString.length();
            int dashIndex = name.indexOf("-");
            if (dashIndex < 0) {
                dashIndex = name.length();
            }
            String templateName = name.substring(projectTemplatesEndIndex, dashIndex);
            return templateName.replace('.', '-');
        }
        catch (Throwable throwable) {
            return name;
        }
    }
}

