/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.control.menu.theme.contributor.internal.template;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuCategory;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.util.ProductNavigationControlMenuCategoryRegistry;
import com.liferay.product.navigation.control.menu.util.ProductNavigationControlMenuEntryRegistry;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"type=THEME"}, service={TemplateContextContributor.class})
public class ProductNavigationControlMenuTemplateContextContributor
implements TemplateContextContributor {
    @Reference
    private ProductNavigationControlMenuCategoryRegistry _productNavigationControlMenuCategoryRegistry;
    @Reference
    private ProductNavigationControlMenuEntryRegistry _productNavigationControlMenuEntryRegistry;

    public void prepare(Map<String, Object> contextObjects, HttpServletRequest httpServletRequest) {
        if (!this.isShowControlMenu(httpServletRequest)) {
            return;
        }
        String cssClass = GetterUtil.getString((Object)contextObjects.get("bodyCssClass"));
        contextObjects.put("bodyCssClass", cssClass + " has-control-menu");
    }

    protected boolean isShowControlMenu(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isSignedIn()) {
            return false;
        }
        String layoutMode = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_l_mode", (String)"view");
        if (layoutMode.equals("preview")) {
            return false;
        }
        User user = themeDisplay.getUser();
        if (!themeDisplay.isImpersonated() && !user.isSetupComplete()) {
            return false;
        }
        List productNavigationControlMenuCategories = this._productNavigationControlMenuCategoryRegistry.getProductNavigationControlMenuCategories("root");
        for (ProductNavigationControlMenuCategory productNavigationControlMenuCategory : productNavigationControlMenuCategories) {
            List productNavigationControlMenuEntries = this._productNavigationControlMenuEntryRegistry.getProductNavigationControlMenuEntries(productNavigationControlMenuCategory, httpServletRequest);
            for (ProductNavigationControlMenuEntry productNavigationControlMenuEntry : productNavigationControlMenuEntries) {
                if (!productNavigationControlMenuEntry.isRelevant(httpServletRequest)) continue;
                return true;
            }
        }
        return false;
    }
}

