/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

(function () {
	var adjustScrollTop = function () {
		var controlMenuContainer;
		var controlMenuContainerScroll;
		var errorFieldLabel;
		var labelScroll;

		errorFieldLabel = document.querySelector(
			'.form-group.has-error .control-label'
		);

		if (errorFieldLabel) {
			labelScroll = errorFieldLabel.clientHeight || 0;

			window.scrollBy(0, -labelScroll);
		}

		controlMenuContainer = document.querySelector(
			'.control-menu-container'
		);

		if (controlMenuContainer) {
			controlMenuContainerScroll = controlMenuContainer.offsetHeight || 0;

			window.scrollBy(0, -controlMenuContainerScroll);
		}
	};

	window.addEventListener('hashchange', adjustScrollTop);

	var handlePageLoad = function () {
		if (window.location.hash) {
			adjustScrollTop();
		}
	};

	window.addEventListener('load', handlePageLoad);

	var handleFormRegistered = function (event) {
		if (event.form && event.form.formValidator) {
			AUI().Do.after(
				adjustScrollTop,
				event.form.formValidator,
				'focusInvalidField'
			);
		}
	};

	Liferay.on('form:registered', handleFormRegistered);
})();
