/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.display.template.test.util;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.dynamic.data.mapping.test.util.DDMTemplateTestUtil;
import com.liferay.exportimport.test.util.lar.BasePortletExportImportTestCase;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.test.TestInfo;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.rule.AggregateTestRule;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.test.rule.LiferayIntegrationTestRule;
import com.liferay.portal.test.rule.PermissionCheckerMethodTestRule;
import com.liferay.portlet.display.template.PortletDisplayTemplate;
import jakarta.portlet.PortletPreferences;
import java.util.Locale;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public abstract class BaseExportImportTestCase
extends BasePortletExportImportTestCase {
    @ClassRule
    @Rule
    public static final AggregateTestRule aggregateTestRule = new AggregateTestRule(new TestRule[]{new LiferayIntegrationTestRule(), PermissionCheckerMethodTestRule.INSTANCE});

    @Test
    @TestInfo(value={"LPD-33733"})
    public void testExportImportDisplayStyleFromDifferentGroup() throws Exception {
        super.testExportImportDisplayStyleFromDifferentGroup();
        long classNameId = PortalUtil.getClassNameId((String)this.getClassName(this.group.getCompanyId()));
        DDMTemplate ddmTemplate = DDMTemplateTestUtil.addTemplate((long)this.group.getGroupId(), (long)classNameId, (long)0L, (long)PortalUtil.getClassNameId((String)PortletDisplayTemplate.class.getName()), (String)"ftl", (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (Locale)PortalUtil.getSiteDefaultLocale((Group)this.group));
        PortletPreferences portletPreferences = this.getImportedPortletPreferences(HashMapBuilder.put((Object)"displayStyle", (Object)new String[]{"ddmTemplate_" + ddmTemplate.getTemplateKey()}).build());
        Assert.assertNotNull((Object)DDMTemplateLocalServiceUtil.getTemplate((long)this.importedGroup.getGroupId(), (long)classNameId, (String)ddmTemplate.getTemplateKey()));
        Assert.assertEquals((Object)("ddmTemplate_" + ddmTemplate.getTemplateKey()), (Object)portletPreferences.getValue("displayStyle", null));
        Assert.assertNull((Object)portletPreferences.getValue("displayStyleGroupExternalReferenceCode", null));
    }

    @Test
    public void testExportImportDisplayStyleFromGlobalScope() throws Exception {
        super.testExportImportDisplayStyleFromGlobalScope();
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)TestPropsValues.getCompanyId());
        long classNameId = PortalUtil.getClassNameId((String)this.getClassName(this.group.getCompanyId()));
        DDMTemplate ddmTemplate = DDMTemplateTestUtil.addTemplate((long)companyGroup.getGroupId(), (long)classNameId, (long)0L, (long)PortalUtil.getClassNameId((String)PortletDisplayTemplate.class.getName()), (String)"ftl", (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (Locale)PortalUtil.getSiteDefaultLocale((Group)companyGroup));
        PortletPreferences portletPreferences = this.getImportedPortletPreferences(HashMapBuilder.put((Object)"displayStyle", (Object)new String[]{"ddmTemplate_" + ddmTemplate.getTemplateKey()}).put((Object)"displayStyleGroupExternalReferenceCode", (Object)new String[]{companyGroup.getExternalReferenceCode()}).build());
        Assert.assertNull((Object)DDMTemplateLocalServiceUtil.fetchTemplate((long)this.importedGroup.getGroupId(), (long)classNameId, (String)ddmTemplate.getTemplateKey()));
        Assert.assertEquals((Object)("ddmTemplate_" + ddmTemplate.getTemplateKey()), (Object)portletPreferences.getValue("displayStyle", null));
        Assert.assertEquals((Object)companyGroup.getExternalReferenceCode(), (Object)portletPreferences.getValue("displayStyleGroupExternalReferenceCode", null));
    }

    protected String getClassName(long companyId) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)this.getPortletId());
        TemplateHandler templateHandler = portlet.getTemplateHandlerInstance();
        if (templateHandler == null) {
            throw new UnsupportedOperationException();
        }
        return templateHandler.getClassName();
    }

    protected void testExportImportDisplayStyle(long displayStyleGroupId, String scopeType) throws Exception {
        Group displayStyleGroup = GroupLocalServiceUtil.getGroup((long)displayStyleGroupId);
        long classNameId = PortalUtil.getClassNameId((String)this.getClassName(this.group.getCompanyId()));
        DDMTemplate ddmTemplate = DDMTemplateTestUtil.addTemplate((long)displayStyleGroup.getGroupId(), (long)classNameId, (long)0L, (long)PortalUtil.getClassNameId((String)PortletDisplayTemplate.class.getName()), (String)"ftl", (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (Locale)PortalUtil.getSiteDefaultLocale((Group)displayStyleGroup));
        PortletPreferences portletPreferences = this.getImportedPortletPreferences(HashMapBuilder.put((Object)"displayStyle", (Object)new String[]{"ddmTemplate_" + ddmTemplate.getTemplateKey()}).put((Object)"displayStyleGroupExternalReferenceCode", () -> {
            if (displayStyleGroup.getGroupId() == this.layout.getGroupId()) {
                return null;
            }
            return new String[]{displayStyleGroup.getExternalReferenceCode()};
        }).build());
        Assert.assertEquals((Object)("ddmTemplate_" + ddmTemplate.getTemplateKey()), (Object)portletPreferences.getValue("displayStyle", null));
        DDMTemplate importedDDMTemplate = DDMTemplateLocalServiceUtil.fetchTemplate((long)this.layout.getGroupId(), (long)classNameId, (String)ddmTemplate.getTemplateKey());
        String importedDisplayStyleGroupExternalReferenceCode = portletPreferences.getValue("displayStyleGroupExternalReferenceCode", null);
        if (displayStyleGroup.getGroupId() != this.layout.getGroupId()) {
            Assert.assertNull((Object)importedDDMTemplate);
            Assert.assertEquals((Object)displayStyleGroup.getExternalReferenceCode(), (Object)importedDisplayStyleGroupExternalReferenceCode);
        } else {
            Assert.assertNotNull((Object)importedDDMTemplate);
            Assert.assertNull((Object)importedDisplayStyleGroupExternalReferenceCode);
        }
    }
}

