/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.display.template.test.util;

import com.liferay.layout.test.util.LayoutTestUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.rule.AggregateTestRule;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.test.rule.Inject;
import com.liferay.portal.test.rule.LiferayIntegrationTestRule;
import com.liferay.portal.test.rule.PermissionCheckerMethodTestRule;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import com.liferay.portal.upgrade.test.util.UpgradeTestUtil;
import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public abstract class BaseUpgradePortletPreferencesTestCase {
    @ClassRule
    @Rule
    public static final AggregateTestRule aggregateTestRule = new AggregateTestRule(new TestRule[]{new LiferayIntegrationTestRule(), PermissionCheckerMethodTestRule.INSTANCE});
    @Inject
    protected EntityCache entityCache;
    @DeleteAfterTestRun
    protected Group group;
    @Inject
    protected GroupLocalService groupLocalService;
    protected Layout layout;
    @Inject
    protected MultiVMPool multiVMPool;
    protected String portletId;

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
        this.layout = LayoutTestUtil.addTypePortletLayout((Group)this.group);
        this.portletId = LayoutTestUtil.addPortletToLayout((Layout)this.layout, (String)this.getPortletId());
    }

    @Test
    public void testUpgradeWithDisplayStyleGroupIdDifferentGroup() throws Exception {
        Group guestGroup = this.groupLocalService.getGroup(TestPropsValues.getCompanyId(), "Guest");
        this.testUpgrade(HashMapBuilder.put((Object)"displayStyleGroupExternalReferenceCode", (Object)guestGroup.getExternalReferenceCode()).put((Object)"displayStyleGroupId", (Object)String.valueOf(guestGroup.getGroupId())).build(), HashMapBuilder.put((Object)"displayStyleGroupId", (Object)String.valueOf(guestGroup.getGroupId())).build());
    }

    @Test
    public void testUpgradeWithDisplayStyleGroupIdGlobalGroup() throws Exception {
        Group companyGroup = this.groupLocalService.getCompanyGroup(TestPropsValues.getCompanyId());
        this.testUpgrade(HashMapBuilder.put((Object)"displayStyleGroupExternalReferenceCode", (Object)companyGroup.getExternalReferenceCode()).put((Object)"displayStyleGroupId", (Object)String.valueOf(companyGroup.getGroupId())).build(), HashMapBuilder.put((Object)"displayStyleGroupId", (Object)String.valueOf(companyGroup.getGroupId())).build());
    }

    @Test
    public void testUpgradeWithDisplayStyleGroupIdMissingGroup() throws Exception {
        this.testUpgrade(HashMapBuilder.put((Object)"displayStyleGroupId", (Object)String.valueOf(RandomTestUtil.randomLong())).build());
    }

    @Test
    public void testUpgradeWithDisplayStyleGroupIdSameGroup() throws Exception {
        this.testUpgrade(HashMapBuilder.put((Object)"displayStyleGroupId", (Object)String.valueOf(this.group.getGroupId())).build());
    }

    @Test
    public void testUpgradeWithDisplayStyleGroupKeyDifferentGroup() throws Exception {
        Group guestGroup = this.groupLocalService.getGroup(TestPropsValues.getCompanyId(), "Guest");
        this.testUpgrade(HashMapBuilder.put((Object)"displayStyleGroupExternalReferenceCode", (Object)guestGroup.getExternalReferenceCode()).put((Object)"displayStyleGroupKey", (Object)guestGroup.getGroupKey()).build(), HashMapBuilder.put((Object)"displayStyleGroupKey", (Object)guestGroup.getGroupKey()).build());
    }

    @Test
    public void testUpgradeWithDisplayStyleGroupKeyGlobalGroup() throws Exception {
        Group companyGroup = this.groupLocalService.getCompanyGroup(TestPropsValues.getCompanyId());
        this.testUpgrade(HashMapBuilder.put((Object)"displayStyleGroupExternalReferenceCode", (Object)companyGroup.getExternalReferenceCode()).put((Object)"displayStyleGroupKey", (Object)companyGroup.getGroupKey()).build(), HashMapBuilder.put((Object)"displayStyleGroupKey", (Object)companyGroup.getGroupKey()).build());
    }

    @Test
    public void testUpgradeWithDisplayStyleGroupKeyMissingGroup() throws Exception {
        this.testUpgrade(HashMapBuilder.put((Object)"displayStyleGroupKey", (Object)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])).build());
    }

    @Test
    public void testUpgradeWithDisplayStyleGroupKeySameGroup() throws Exception {
        this.testUpgrade(HashMapBuilder.put((Object)"displayStyleGroupKey", (Object)this.group.getGroupKey()).build());
    }

    @Test
    public void testUpgradeWithNullDisplayStyleGroup() throws Exception {
        this.testUpgrade(Collections.emptyMap());
    }

    protected void assertPortletPreferences(Map<String, String> expectedMap) throws Exception {
        PortletPreferences portletPreferences = LayoutTestUtil.getPortletPreferences((Layout)this.layout, (String)this.portletId);
        Map map = portletPreferences.getMap();
        Assert.assertEquals((String)MapUtil.toString((Map)map), (long)expectedMap.size(), (long)map.size());
        for (Map.Entry<String, String> entry : expectedMap.entrySet()) {
            Assert.assertTrue((String)entry.getKey(), (boolean)map.containsKey(entry.getKey()));
            Assert.assertArrayEquals((Object[])new String[]{entry.getValue()}, (Object[])((Object[])map.get(entry.getKey())));
        }
    }

    protected abstract String getPortletId();

    protected UpgradeProcess getUpgradeProcess() {
        UpgradeProcess[] upgradeProcesses = UpgradeTestUtil.getUpgradeSteps((UpgradeStepRegistrator)this.getUpgradeStepRegistrator(), (Version)this.getVersion());
        return upgradeProcesses[0];
    }

    protected abstract UpgradeStepRegistrator getUpgradeStepRegistrator();

    protected abstract Version getVersion();

    protected void runUpgrade() throws Exception {
        UpgradeProcess upgradeProcess = this.getUpgradeProcess();
        upgradeProcess.upgrade();
        this.entityCache.clearCache();
        this.multiVMPool.clear();
    }

    protected void testUpgrade(Map<String, String> map) throws Exception {
        this.testUpgrade(map, map);
    }

    protected void testUpgrade(Map<String, String> expectedMap, Map<String, String> map) throws Exception {
        this.updateLayoutPortletPreference(map);
        this.runUpgrade();
        this.assertPortletPreferences(expectedMap);
    }

    protected void updateLayoutPortletPreference(Map<String, String> portletPreferencesMap) throws Exception {
        LayoutTestUtil.updateLayoutPortletPreferences((Layout)this.layout, (String)this.portletId, portletPreferencesMap);
        this.assertPortletPreferences(portletPreferencesMap);
    }
}

