/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSink;
import net.coobird.thumbnailator.util.BufferedImages;
import net.coobird.thumbnailator.util.ThumbnailatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStreamImageSink
extends AbstractImageSink<OutputStream> {
    private final OutputStream os;

    public OutputStreamImageSink(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("OutputStream cannot be null.");
        }
        this.os = outputStream;
    }

    @Override
    public void write(BufferedImage bufferedImage) throws IOException {
        List<String> list;
        super.write(bufferedImage);
        if (this.outputFormat == null) {
            throw new IllegalStateException("Output format has not been set.");
        }
        String string = this.outputFormat;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (!iterator.hasNext()) {
            throw new UnsupportedFormatException(string, "No suitable ImageWriter found for " + string + ".");
        }
        ImageWriter imageWriter = iterator.next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriteParam.canWriteCompressed() && this.param != null) {
            imageWriteParam.setCompressionMode(2);
            if (this.param.getOutputFormatType() != ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
                imageWriteParam.setCompressionType(this.param.getOutputFormatType());
            } else {
                list = ThumbnailatorUtils.getSupportedOutputFormatTypes(string);
                if (!list.isEmpty()) {
                    imageWriteParam.setCompressionType((String)list.get(0));
                }
            }
            if (!Float.isNaN(this.param.getOutputQuality())) {
                imageWriteParam.setCompressionQuality(this.param.getOutputQuality());
            }
        }
        if ((list = ImageIO.createImageOutputStream(this.os)) == null) {
            throw new IOException("Could not open OutputStream.");
        }
        if (string.equalsIgnoreCase("jpg") || string.equalsIgnoreCase("jpeg") || string.equalsIgnoreCase("bmp")) {
            bufferedImage = BufferedImages.copy(bufferedImage, 1);
        }
        imageWriter.setOutput(list);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
        imageWriter.dispose();
        list.close();
    }

    @Override
    public OutputStream getSink() {
        return this.os;
    }
}

