/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.theme.builder;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.liferay.portal.tools.theme.builder.ThemeBuilderArgs;
import com.liferay.portal.tools.theme.builder.internal.util.FileUtil;
import com.liferay.portal.tools.theme.builder.internal.util.Validator;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.coobird.thumbnailator.Thumbnails;

public class ThemeBuilder {
    public static final String STYLED = "_styled";
    public static final String UNSTYLED = "_unstyled";
    private final File _diffsDir;
    private final String _name;
    private final File _outputDir;
    private final File _parentDir;
    private final String _parentName;
    private final String _templateExtension;
    private final File _unstyledDir;

    public static void main(String[] args) throws Exception {
        ThemeBuilderArgs themeBuilderArgs = new ThemeBuilderArgs();
        JCommander jCommander = new JCommander(themeBuilderArgs);
        try {
            File jarFile = FileUtil.getJarFile();
            if (jarFile.isFile()) {
                jCommander.setProgramName("java -jar " + jarFile.getName());
            } else {
                jCommander.setProgramName(ThemeBuilder.class.getName());
            }
            jCommander.parse(args);
            if (themeBuilderArgs.isHelp()) {
                ThemeBuilder._printHelp(jCommander);
            } else {
                ThemeBuilder themeBuilder = new ThemeBuilder(themeBuilderArgs);
                themeBuilder.build();
            }
        }
        catch (ParameterException pe) {
            System.err.println(pe.getMessage());
            ThemeBuilder._printHelp(jCommander);
        }
    }

    public ThemeBuilder(File diffsDir, String name, File outputDir, File parentDir, String parentName, String templateExtension, File unstyledDir) {
        if (Validator.isNull(name)) {
            name = ThemeBuilderArgs.DEFAULT_NAME;
        }
        if (outputDir == null) {
            throw new IllegalArgumentException("The output directory is required");
        }
        if (parentDir == null) {
            if (Validator.isNotNull(parentName) && (unstyledDir == null || unstyledDir != null && !parentName.equals(UNSTYLED))) {
                throw new IllegalArgumentException("Parent path is required");
            }
        } else {
            if (Validator.isNull(parentName)) {
                throw new IllegalArgumentException("Parent name is required");
            }
            if (!parentName.equals(UNSTYLED) && unstyledDir == null) {
                throw new IllegalArgumentException("Unstyled path is required");
            }
            if (parentName.equals(UNSTYLED) && unstyledDir != null) {
                unstyledDir = parentDir;
                parentDir = null;
            }
        }
        templateExtension = Validator.isNull(templateExtension) ? "ftl" : templateExtension.toLowerCase();
        this._diffsDir = diffsDir;
        this._name = name;
        this._outputDir = outputDir;
        this._parentDir = parentDir;
        this._parentName = parentName;
        this._templateExtension = templateExtension;
        this._unstyledDir = unstyledDir;
        System.setProperty("java.awt.headless", "true");
    }

    public ThemeBuilder(ThemeBuilderArgs themeBuilderArgs) {
        this(themeBuilderArgs.getDiffsDir(), themeBuilderArgs.getName(), themeBuilderArgs.getOutputDir(), themeBuilderArgs.getParentDir(), themeBuilderArgs.getParentName(), themeBuilderArgs.getTemplateExtension(), themeBuilderArgs.getUnstyledDir());
    }

    public void build() throws Exception {
        if (this._unstyledDir != null) {
            this._copyTheme(UNSTYLED, this._unstyledDir);
        }
        if (this._parentDir != null) {
            this._copyTheme(this._parentName, this._parentDir);
        }
        this._writeLookAndFeelXml();
        if (this._diffsDir != null) {
            this._copyTheme(this._diffsDir.toPath());
        }
        this._writeScreenshotThumbnail();
    }

    private static void _printHelp(JCommander jCommander) throws Exception {
        jCommander.usage();
    }

    private void _copyTheme(final Path themeDirPath) throws IOException {
        final Path outputDirPath = this._outputDir.toPath();
        Files.walkFileTree(themeDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (ThemeBuilder.this._isIgnoredFile(path.toString())) {
                    return FileVisitResult.CONTINUE;
                }
                String relativePath = String.valueOf(themeDirPath.relativize(path));
                Path outputPath = outputDirPath.resolve(relativePath);
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                Files.copy(path, outputPath, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void _copyTheme(String themeName, File themeDir) throws Exception {
        Path themePath = themeDir.toPath();
        if (Files.isDirectory(themePath, new LinkOption[0])) {
            this._copyTheme(themePath);
        } else {
            URI uri = themePath.toUri();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("create", "false");
            properties.put("encoding", StandardCharsets.UTF_8.name());
            try (FileSystem fileSystem = FileSystems.newFileSystem(new URI("jar:" + uri.getScheme(), uri.getPath(), null), properties);){
                String extension = FileUtil.getExtension(String.valueOf(themePath.getFileName()));
                if (extension.equalsIgnoreCase("jar")) {
                    this._copyTheme(fileSystem.getPath("/META-INF/resources/" + themeName, new String[0]));
                } else {
                    this._copyTheme(fileSystem.getPath("/", new String[0]));
                }
            }
        }
    }

    private boolean _isIgnoredFile(String fileName) {
        String extension = FileUtil.getExtension(fileName);
        if ((extension.equalsIgnoreCase("ftl") || extension.equalsIgnoreCase("vm")) && !extension.equalsIgnoreCase(this._templateExtension)) {
            return true;
        }
        return fileName.endsWith("aui.css") || fileName.endsWith("main.css") || fileName.endsWith("rtl.css");
    }

    private void _writeLookAndFeelXml() throws IOException {
        Path path = this._outputDir.toPath();
        if (Files.exists(path = path.resolve("WEB-INF/liferay-look-and-feel.xml"), new LinkOption[0])) {
            return;
        }
        String content = FileUtil.read(ThemeBuilder.class, "dependencies/liferay-look-and-feel.xml");
        String id = this._name.toLowerCase();
        id = id.replaceAll(" ", "_");
        content = content.replace("[$ID$]", id);
        content = content.replace("[$NAME$]", this._name);
        content = content.replace("[$TEMPLATE_EXTENSION$]", this._templateExtension);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void _writeScreenshotThumbnail() throws IOException {
        File file = new File(this._outputDir, "images/screenshot.png");
        if (!file.exists()) {
            return;
        }
        Thumbnails.Builder<File> thumbnailBuilder = Thumbnails.of(file);
        thumbnailBuilder.outputFormat("png");
        thumbnailBuilder.size(160, 120);
        thumbnailBuilder.toFile(new File(this._outputDir, "images/thumbnail.png"));
    }
}

