/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ProxyFactory {
    public static <T> T newDummyInstance(Class<T> interfaceClass) {
        return (T)ProxyUtil.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new DummyInvocationHandler());
    }

    public static Object newInstance(ClassLoader classLoader, Class<?> interfaceClass, String implClassName) throws Exception {
        return ProxyFactory.newInstance(classLoader, new Class[]{interfaceClass}, implClassName);
    }

    public static Object newInstance(ClassLoader classLoader, Class<?>[] interfaceClasses, String implClassName) throws Exception {
        Object instance = InstanceFactory.newInstance(classLoader, implClassName);
        return ProxyUtil.newProxyInstance(classLoader, interfaceClasses, (InvocationHandler)new ClassLoaderBeanHandler(instance, classLoader));
    }

    private static class DummyInvocationHandler<T>
    implements InvocationHandler {
        private DummyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(Boolean.TYPE)) {
                return false;
            }
            if (returnType.equals(Byte.TYPE)) {
                return (byte)0;
            }
            if (returnType.equals(Double.TYPE)) {
                return 0.0;
            }
            if (returnType.equals(Float.TYPE)) {
                return Float.valueOf(0.0f);
            }
            if (returnType.equals(Integer.TYPE)) {
                return 0;
            }
            if (returnType.equals(Long.TYPE)) {
                return 0L;
            }
            if (returnType.equals(Short.TYPE)) {
                return (short)0;
            }
            return method.getDefaultValue();
        }
    }
}

