/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.db.IndexMetadataFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class IndexMetadata
extends Index
implements Comparable<IndexMetadata> {
    private final String[] _columnNames;
    private final String _dropSQL;

    public IndexMetadata(String indexName, String tableName, boolean unique, String ... columnNames) {
        super(indexName, tableName, unique);
        if (columnNames == null) {
            throw new NullPointerException("Column names are missing");
        }
        this._columnNames = columnNames;
        this._dropSQL = StringBundler.concat("drop index ", indexName, " on ", tableName, ";");
    }

    @Override
    public int compareTo(IndexMetadata indexMetadata) {
        String columnNames = StringUtil.merge(this.getColumnNames());
        String indexMetadataColumnNames = StringUtil.merge(indexMetadata.getColumnNames());
        return columnNames.compareTo(indexMetadataColumnNames);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IndexMetadata)) {
            return false;
        }
        IndexMetadata indexMetadata = (IndexMetadata)object;
        return Objects.equals(this.getTableName(), indexMetadata.getTableName()) && Arrays.equals(this._columnNames, indexMetadata._columnNames);
    }

    public String[] getColumnNames() {
        String[] columnNames = (String[])this._columnNames.clone();
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this._trimColumnName(columnNames[i]);
        }
        return columnNames;
    }

    public String getCreateSQL(int[] lengths) {
        int sbSize = 8 + this._columnNames.length * 2;
        if (lengths != null) {
            sbSize += this._columnNames.length * 3;
        }
        StringBundler sb = new StringBundler(sbSize);
        if (this.isUnique()) {
            sb.append("create unique ");
        } else {
            sb.append("create ");
        }
        sb.append("index ");
        sb.append(this.getIndexName());
        sb.append(" on ");
        sb.append(this.getTableName());
        sb.append(" ");
        sb.append("(");
        for (int i = 0; i < this._columnNames.length; ++i) {
            sb.append(this._columnNames[i]);
            if (lengths != null && lengths[i] > 0) {
                sb.append("[$COLUMN_LENGTH:");
                sb.append(lengths[i]);
                sb.append("$]");
            }
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        sb.append(";");
        return sb.toString();
    }

    public String getDropSQL() {
        return this._dropSQL;
    }

    @Override
    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (Object)this.getTableName());
        for (String columnName : this._columnNames) {
            hashCode = HashUtil.hash((int)hashCode, (Object)columnName);
        }
        return hashCode;
    }

    public void optimizeColumns(Map<String, IntegerWrapper> frequencyMap) {
        Arrays.sort(this._columnNames, (columnName1, columnName2) -> {
            IntegerWrapper count1 = (IntegerWrapper)frequencyMap.get(this._trimColumnName((String)columnName1));
            IntegerWrapper count2 = (IntegerWrapper)frequencyMap.get(this._trimColumnName((String)columnName2));
            return count2.compareTo(count1);
        });
        this.indexName = IndexMetadataFactoryUtil.createIndexName(this.getTableName(), this.getColumnNames());
    }

    public Boolean redundantTo(IndexMetadata indexMetadata) {
        Object[] indexMetadataColumnNames = indexMetadata._columnNames;
        if (indexMetadata.isUnique() && this.isUnique()) {
            if (this._columnNames.length <= indexMetadataColumnNames.length && ArrayUtil.containsAll(indexMetadataColumnNames, this._columnNames)) {
                return Boolean.FALSE;
            }
            if (this._columnNames.length > indexMetadataColumnNames.length && ArrayUtil.containsAll(this._columnNames, indexMetadataColumnNames)) {
                return Boolean.TRUE;
            }
        }
        if (this._columnNames.length <= indexMetadataColumnNames.length) {
            for (int i = 0; i < this._columnNames.length; ++i) {
                if (this._columnNames[i].equals(indexMetadataColumnNames[i])) continue;
                return null;
            }
            if (this.isUnique()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        Boolean redundant = indexMetadata.redundantTo(this);
        if (redundant == null) {
            return null;
        }
        return redundant == false;
    }

    @Override
    public String toString() {
        return this.getCreateSQL(null);
    }

    private String _trimColumnName(String columnName) {
        int index = columnName.indexOf("[$COLUMN_LENGTH:");
        if (index > 0) {
            columnName = columnName.substring(0, index);
        }
        return columnName;
    }
}

