/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.function.Consumer;

public class ReflectionUtil {
    public static Field getDeclaredField(Class<?> clazz, String name) throws Exception {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws Exception {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
        }
        return fields;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        Method method = clazz.getDeclaredMethod(name, parameterTypes);
        method.setAccessible(true);
        return method;
    }

    public static Class<?>[] getInterfaces(Object object) {
        return ReflectionUtil.getInterfaces(object, null);
    }

    public static Class<?>[] getInterfaces(Object object, ClassLoader classLoader) {
        return ReflectionUtil.getInterfaces(object, classLoader, cnfe -> {});
    }

    public static Class<?>[] getInterfaces(Object object, ClassLoader classLoader, Consumer<ClassNotFoundException> classNotFoundHandler) {
        LinkedHashSet interfaceClasses = new LinkedHashSet();
        for (Class<?> superClass = object.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Class<?> interfaceClass : superClass.getInterfaces()) {
                try {
                    if (classLoader == null) {
                        interfaceClasses.add(interfaceClass);
                        continue;
                    }
                    interfaceClasses.add(classLoader.loadClass(interfaceClass.getName()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundHandler.accept(classNotFoundException);
                }
            }
        }
        return interfaceClasses.toArray(new Class[0]);
    }

    public static <T> T throwException(Throwable throwable) {
        return ReflectionUtil._throwException(throwable);
    }

    private static <T, E extends Throwable> T _throwException(Throwable throwable) throws E {
        throw throwable;
    }
}

