/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sample.sql.builder;

import com.liferay.petra.io.OutputStreamWriter;
import com.liferay.petra.io.unsync.UnsyncBufferedReader;
import com.liferay.petra.io.unsync.UnsyncBufferedWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.tools.sample.sql.builder.BenchmarksPropsValues;
import com.liferay.portal.tools.sample.sql.builder.CSVFileWriter;
import com.liferay.portal.tools.sample.sql.builder.DataFactory;
import com.liferay.portal.tools.sample.sql.builder.SampleMySQLDB;
import com.liferay.portal.tools.sample.sql.builder.SamplePostgreSQLDB;
import com.liferay.portal.tools.sample.sql.builder.io.CharPipe;
import com.liferay.portal.tools.sample.sql.builder.io.UnsyncTeeWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SampleSQLBuilder {
    private static final String _OUTPUT_DIR = System.getProperty("user.dir");
    private static final int _PIPE_BUFFER_SIZE = 0x1000000;
    private static final int _WRITER_BUFFER_SIZE = 16384;
    private static final List<String> _createSQLTemplateFileNames = Arrays.asList("com/liferay/portal/tools/sql/dependencies/portal-tables.sql", "com/liferay/portal/tools/sql/dependencies/portal-data-counter.sql", "com/liferay/portal/tools/sql/dependencies/indexes.sql", "META-INF/sql/tables.sql", "META-INF/sql/indexes.sql");
    private volatile Throwable _freeMarkerThrowable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleSQLBuilder() {
        ToolDependencies.wireBasic();
        File tempDir = new File(_OUTPUT_DIR, "temp");
        tempDir.mkdirs();
        Reader reader = this.generateSQL();
        try {
            this.compressSQL(reader, tempDir);
            if (BenchmarksPropsValues.OUTPUT_MERGE) {
                File sqlFile = new File(_OUTPUT_DIR, "sample-" + BenchmarksPropsValues.DB_TYPE + ".sql");
                FileUtil.delete((File)sqlFile);
                this.mergeSQL(tempDir, sqlFile);
            } else {
                File outputDir = new File(_OUTPUT_DIR, "output");
                FileUtil.deltree((File)outputDir);
                if (!tempDir.renameTo(outputDir)) {
                    FileUtil.copyDirectory((File)tempDir, (File)outputDir);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            FileUtil.deltree((File)tempDir);
        }
    }

    protected void compressSQL(DB db, File directory, Map<String, Writer> sqlWriters, Map<String, StringBundler> sqls, String sql) throws IOException, SQLException {
        String tableName = null;
        if (sql.startsWith("create")) {
            if (sql.startsWith("create table ")) {
                tableName = sql.substring(13, sql.indexOf("(") - 1);
            } else {
                int index = sql.indexOf(" on ");
                tableName = sql.substring(index + 4, sql.indexOf("(") - 1);
            }
            sql = db.buildSQL(sql) + "\n";
            this.writeToSQLFile(directory, tableName, sqlWriters, sql);
            return;
        }
        sql = sql.substring(12);
        tableName = sql.substring(0, sql.indexOf(32));
        int index = sql.indexOf(" values ") + 8;
        StringBundler sb = sqls.get(tableName);
        if (sb == null || sb.index() == 0) {
            sb = new StringBundler();
            sqls.put(tableName, sb);
            sb.append("insert into ");
            sb.append(sql.substring(0, index));
            sb.append("\n");
        } else {
            sb.append(",");
            sb.append("\n");
        }
        String values = sql.substring(index, sql.length() - 1);
        sb.append(values);
        if (sb.index() >= BenchmarksPropsValues.OPTIMIZE_BUFFER_SIZE) {
            sb.append(";");
            sb.append("\n");
            sql = db.buildSQL(sb.toString());
            sb.setIndex(0);
            this.writeToSQLFile(directory, tableName, sqlWriters, sql);
        }
    }

    protected void compressSQL(Reader reader, File dir) throws Exception {
        StringBundler sb;
        Object db = DBManagerUtil.getDB((DBType)BenchmarksPropsValues.DB_TYPE, null);
        if (BenchmarksPropsValues.DB_TYPE == DBType.MARIADB || BenchmarksPropsValues.DB_TYPE == DBType.MYSQL) {
            db = new SampleMySQLDB(db.getMajorVersion(), db.getMinorVersion());
        } else if (BenchmarksPropsValues.DB_TYPE == DBType.POSTGRESQL) {
            db = new SamplePostgreSQLDB(db.getMajorVersion(), db.getMinorVersion());
        }
        HashMap<String, Writer> sqlWriters = new HashMap<String, Writer>();
        HashMap<String, StringBundler> insertSQLs = new HashMap<String, StringBundler>();
        ArrayList<String> counterSQLs = new ArrayList<String>();
        Throwable throwable = null;
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);){
            String s = null;
            while (this._freeMarkerThrowable == null && (s = unsyncBufferedReader.readLine()) != null) {
                if ((s = s.trim()).length() <= 0) continue;
                if (s.startsWith("create") || s.startsWith("insert into ")) {
                    if (!s.endsWith(");")) {
                        sb = new StringBundler();
                        while (!s.endsWith(");")) {
                            sb.append(s);
                            sb.append("\n");
                            s = unsyncBufferedReader.readLine();
                        }
                        sb.append(s);
                        s = sb.toString();
                    }
                    this.compressSQL((DB)db, dir, (Map<String, Writer>)sqlWriters, (Map<String, StringBundler>)insertSQLs, s);
                    continue;
                }
                if (s.contains("##")) continue;
                counterSQLs.add(s);
            }
        }
        catch (Throwable s) {
            Throwable throwable2 = s;
            throw s;
        }
        if (this._freeMarkerThrowable != null) {
            throw new Exception("Unable to process FreeMarker template ", this._freeMarkerThrowable);
        }
        for (Map.Entry entry : insertSQLs.entrySet()) {
            String tableName = (String)entry.getKey();
            sb = (StringBundler)entry.getValue();
            if (sb.index() > 0) {
                String insertSQL = db.buildSQL(sb.toString());
                this.writeToSQLFile(dir, tableName, sqlWriters, insertSQL);
            }
            Writer insertSQLWriter = (Writer)sqlWriters.remove(tableName);
            Throwable throwable3 = null;
            try {
                insertSQLWriter.write(";");
                insertSQLWriter.write("\n");
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                if (insertSQLWriter == null) continue;
                if (throwable3 != null) {
                    try {
                        insertSQLWriter.close();
                    }
                    catch (Throwable throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    continue;
                }
                insertSQLWriter.close();
            }
        }
        for (Map.Entry entry : sqlWriters.entrySet()) {
            Writer writer = (Writer)entry.getValue();
            writer.close();
        }
        Throwable throwable6 = null;
        try (FileWriter counterSQLWriter = new FileWriter(new File(dir, "Counter.sql"), true);){
            for (String counterSQL : counterSQLs) {
                counterSQL = db.buildSQL(counterSQL);
                counterSQLWriter.write(counterSQL);
                counterSQLWriter.write("\n");
            }
        }
        catch (Throwable throwable7) {
            Throwable throwable8 = throwable7;
            throw throwable7;
        }
    }

    protected Writer createFileWriter(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream);
        return new UnsyncBufferedWriter((Writer)writer, 16384);
    }

    protected Reader generateSQL() {
        CharPipe charPipe = new CharPipe(0x1000000);
        Thread thread = new Thread(() -> {
            try (CSVFileWriter csvFileWriter = new CSVFileWriter(new File(_OUTPUT_DIR));
                 UnsyncTeeWriter sampleSQLWriter = new UnsyncTeeWriter((Writer)new UnsyncBufferedWriter(charPipe.getWriter(), 16384), this.createFileWriter(new File(_OUTPUT_DIR, "sample.sql")));){
                this._loadCreateSQLs(sampleSQLWriter);
                FreeMarkerUtil.process((String)BenchmarksPropsValues.SCRIPT, (Object)HashMapBuilder.put((Object)"csvFileWriter", (Object)csvFileWriter).put((Object)"dataFactory", (Object)new DataFactory()).build(), (Writer)sampleSQLWriter);
            }
            catch (Throwable throwable) {
                this._freeMarkerThrowable = throwable;
            }
            finally {
                charPipe.close();
            }
        });
        thread.start();
        return charPipe.getReader();
    }

    protected void mergeSQL(File inputDir, File outputSQLFile) throws IOException {
        FileOutputStream outputSQLFileOutputStream = new FileOutputStream(outputSQLFile);
        try (FileChannel outputFileChannel = outputSQLFileOutputStream.getChannel();){
            File counterSQLFile = null;
            for (File inputFile : inputDir.listFiles()) {
                String inputFileName = inputFile.getName();
                if (inputFileName.equals("Counter.sql")) {
                    counterSQLFile = inputFile;
                    continue;
                }
                this.mergeSQL(inputFile, outputFileChannel);
            }
            if (counterSQLFile != null) {
                this.mergeSQL(counterSQLFile, outputFileChannel);
            }
        }
    }

    protected void mergeSQL(File inputFile, FileChannel outputFileChannel) throws IOException {
        FileInputStream inputFileInputStream = new FileInputStream(inputFile);
        try (FileChannel inputFileChannel = inputFileInputStream.getChannel();){
            inputFileChannel.transferTo(0L, inputFileChannel.size(), outputFileChannel);
        }
        inputFile.delete();
    }

    protected void writeToSQLFile(File dir, String tableName, Map<String, Writer> sqlWriters, String sql) throws IOException {
        Writer writer = sqlWriters.get(tableName);
        if (writer == null) {
            File file = new File(dir, tableName + ".sql");
            writer = this.createFileWriter(file);
            sqlWriters.put(tableName, writer);
        }
        writer.write(sql);
    }

    private void _loadCreateSQL(URL url, Writer writer) throws IOException {
        try (InputStream inputStream = url.openStream();
             InputStreamReader reader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                writer.append(line);
                writer.append(System.lineSeparator());
            }
        }
    }

    private void _loadCreateSQLs(Writer writer) throws IOException {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        for (String sqlFileName : _createSQLTemplateFileNames) {
            if (sqlFileName.contains("META-INF")) {
                Enumeration<URL> enumeration = classLoader.getResources(sqlFileName);
                while (enumeration.hasMoreElements()) {
                    this._loadCreateSQL(enumeration.nextElement(), writer);
                }
                continue;
            }
            this._loadCreateSQL(classLoader.getResource(sqlFileName), writer);
        }
        writer.flush();
    }
}

