/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sample.sql.builder;

import com.liferay.petra.io.OutputStreamWriter;
import com.liferay.petra.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.tools.sample.sql.builder.BenchmarksPropsValues;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class CSVFileWriter
implements AutoCloseable {
    private static final int _WRITER_BUFFER_SIZE = 16384;
    private final Map<String, Writer> _csvWriters = new HashMap<String, Writer>();

    public CSVFileWriter(File outputDir) throws FileNotFoundException {
        outputDir.mkdirs();
        for (String csvFileName : BenchmarksPropsValues.OUTPUT_CSV_FILE_NAMES) {
            this._csvWriters.put(csvFileName, (Writer)new UnsyncBufferedWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputDir, csvFileName.concat(".csv")))), 16384));
        }
    }

    @Override
    public void close() throws IOException {
        for (Writer writer : this._csvWriters.values()) {
            writer.close();
        }
    }

    public void write(String csvFileName, String content) throws IOException {
        Writer writer = this._csvWriters.get(csvFileName);
        if (writer == null) {
            throw new IllegalArgumentException("Unknown CSV file name: " + csvFileName);
        }
        writer.write(content);
    }
}

