/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Time {
    public static final long DAY = 86400000L;
    public static final String DURATION_FORMAT = "HH:mm:ss.SSS";
    public static final long HOUR = 3600000L;
    public static final long MINUTE = 60000L;
    public static final long MONTH = 2592000000L;
    public static final String RFC822_FORMAT = "EEE, dd MMM yyyy HH:mm:ss Z";
    public static final long SECOND = 1000L;
    public static final String SHORT_TIMESTAMP_FORMAT = "yyyyMMddkkmm";
    public static final String TIMESTAMP_FORMAT = "yyyyMMddkkmmssSSS";
    public static final long WEEK = 604800000L;
    public static final long YEAR = 31536000000L;

    public static Date getDate(Calendar cal) {
        Calendar adjustedCal = CalendarFactoryUtil.getCalendar();
        adjustedCal.set(1, cal.get(1));
        adjustedCal.set(2, cal.get(2));
        adjustedCal.set(5, cal.get(5));
        adjustedCal.set(11, cal.get(11));
        adjustedCal.set(12, cal.get(12));
        adjustedCal.set(13, cal.get(13));
        adjustedCal.set(14, cal.get(14));
        return adjustedCal.getTime();
    }

    public static Date getDate(Date date, TimeZone tz) {
        Calendar cal = CalendarFactoryUtil.getCalendar(tz);
        cal.setTime(date);
        return Time.getDate(cal);
    }

    public static Date getDate(TimeZone tz) {
        Calendar cal = CalendarFactoryUtil.getCalendar(tz);
        return Time.getDate(cal);
    }

    public static String getDescription(long milliseconds) {
        return Time.getDescription(milliseconds, false);
    }

    public static String getDescription(long milliseconds, boolean approximate) {
        String s = "";
        int x = 0;
        if (approximate) {
            if (milliseconds <= 0L) {
                s = "0 Second";
            } else if (milliseconds < 60000L) {
                x = (int)(milliseconds / 1000L);
                s = x + " Second";
            } else if (milliseconds < 3600000L) {
                x = (int)(milliseconds / 60000L);
                s = x + " Minute";
            } else if (milliseconds < 86400000L) {
                x = (int)(milliseconds / 3600000L);
                s = x + " Hour";
            } else if (milliseconds < 2592000000L) {
                x = (int)(milliseconds / 86400000L);
                s = x + " Day";
            } else if (milliseconds < 31536000000L) {
                x = (int)(milliseconds / 2592000000L);
                s = x + " Month";
            } else if (milliseconds >= 31536000000L) {
                x = (int)(milliseconds / 31536000000L);
                s = x + " Year";
            }
        } else if (milliseconds % 604800000L == 0L) {
            x = (int)(milliseconds / 604800000L);
            s = x + " Week";
        } else if (milliseconds % 86400000L == 0L) {
            x = (int)(milliseconds / 86400000L);
            s = x + " Day";
        } else if (milliseconds % 3600000L == 0L) {
            x = (int)(milliseconds / 3600000L);
            s = x + " Hour";
        } else if (milliseconds % 60000L == 0L) {
            x = (int)(milliseconds / 60000L);
            s = x + " Minute";
        } else if (milliseconds % 1000L == 0L) {
            x = (int)(milliseconds / 1000L);
            s = x + " Second";
        } else {
            x = (int)milliseconds;
            s = x + " Millisecond";
        }
        if (x == 0 || x > 1) {
            s = s + "s";
        }
        return s;
    }

    public static String getDuration(long milliseconds) {
        return Time.getSimpleDate(new Date(milliseconds), DURATION_FORMAT);
    }

    public static String getRelativeTimeDescription(Date date, Locale locale, TimeZone timeZone) {
        return Time.getRelativeTimeDescription(date.getTime(), locale, timeZone);
    }

    public static String getRelativeTimeDescription(Date date, Locale locale, TimeZone timeZone, Format dateTimeFormat) {
        return Time.getRelativeTimeDescription(date.getTime(), locale, timeZone, dateTimeFormat);
    }

    public static String getRelativeTimeDescription(long milliseconds, Locale locale, TimeZone timeZone) {
        return Time.getRelativeTimeDescription(milliseconds, locale, timeZone, null);
    }

    public static String getRelativeTimeDescription(long milliseconds, Locale locale, TimeZone timeZone, Format dateTimeFormat) {
        int daysBetween = DateUtil.getDaysBetween(new Date(milliseconds), new Date(), timeZone);
        long millisAgo = System.currentTimeMillis() - milliseconds;
        if (millisAgo < 3600000L) {
            long minutes = millisAgo / 60000L;
            if (minutes <= 1L) {
                return LanguageUtil.get((Locale)locale, (String)"about-a-minute-ago");
            }
            return LanguageUtil.format((Locale)locale, (String)"x-minutes-ago", (Object)minutes, (boolean)false);
        }
        if (millisAgo / 3600000L == 1L) {
            return LanguageUtil.get((Locale)locale, (String)"about-an-hour-ago");
        }
        if (millisAgo < 86400000L || daysBetween == 0) {
            return LanguageUtil.format((Locale)locale, (String)"x-hours-ago", (Object)(millisAgo / 3600000L), (boolean)false);
        }
        if (daysBetween == 1) {
            Format timeFormat = FastDateFormatFactoryUtil.getTime(locale, timeZone);
            return LanguageUtil.format((Locale)locale, (String)"yesterday-at-x", (Object)timeFormat.format(milliseconds), (boolean)false);
        }
        if (dateTimeFormat == null) {
            dateTimeFormat = FastDateFormatFactoryUtil.getSimpleDateFormat("EEEE, MMMMM dd, yyyy", locale, timeZone);
        }
        return dateTimeFormat.format(milliseconds);
    }

    public static String getRFC822() {
        return Time.getRFC822(new Date());
    }

    public static String getRFC822(Date date) {
        return Time.getSimpleDate(date, RFC822_FORMAT);
    }

    public static String getShortTimestamp() {
        return Time.getShortTimestamp(new Date());
    }

    public static String getShortTimestamp(Date date) {
        return Time.getSimpleDate(date, SHORT_TIMESTAMP_FORMAT);
    }

    public static String getSimpleDate(Date date, String format) {
        String s = "";
        if (date != null) {
            Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat(format);
            s = dateFormat.format(date);
        }
        return s;
    }

    public static String getTimestamp() {
        return Time.getTimestamp(new Date());
    }

    public static String getTimestamp(Date date) {
        return Time.getSimpleDate(date, TIMESTAMP_FORMAT);
    }
}

