/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassLoaderProxy {
    private static final Log _log = LogFactoryUtil.getLog(ClassLoaderProxy.class);
    private final ClassLoader _classLoader;
    private final String _className;
    private final Object _object;

    public ClassLoaderProxy(Object object, ClassLoader classLoader) {
        this(object, object.getClass().getName(), classLoader);
    }

    public ClassLoaderProxy(Object object, String className, ClassLoader classLoader) {
        this._object = object;
        this._className = className;
        this._classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getClassName() {
        return this._className;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodHandler methodHandler) throws Throwable {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)this._classLoader);){
            Object object = this._invoke(methodHandler);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.translateThrowable(invocationTargetException.getCause(), contextClassLoader);
        }
        catch (Throwable throwable) {
            _log.error(throwable, throwable);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Throwable translateThrowable(Throwable throwable, ClassLoader contextClassLoader) {
        try {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(unsyncByteArrayOutputStream);){
                objectOutputStream.writeObject(throwable);
                objectOutputStream.flush();
            }
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
            try (ClassLoaderObjectInputStream objectInputStream = new ClassLoaderObjectInputStream(unsyncByteArrayInputStream, contextClassLoader);){
                Throwable throwable2 = (Throwable)objectInputStream.readObject();
                return throwable2;
            }
        }
        catch (Throwable throwable22) {
            _log.error(throwable22, throwable22);
            return throwable22;
        }
    }

    private Object _invoke(MethodHandler methodHandler) throws Exception {
        try {
            return methodHandler.invoke(this._object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            MethodKey methodKey = methodHandler.getMethodKey();
            String name = methodKey.getMethodName();
            Class<?>[] parameterTypes = methodKey.getParameterTypes();
            Class<?> clazz = Class.forName(this._className, true, this._classLoader);
            for (Method method : clazz.getMethods()) {
                String curName = method.getName();
                Class<?>[] curParameterTypes = method.getParameterTypes();
                if (!curName.equals(name) || curParameterTypes.length != parameterTypes.length) continue;
                boolean correctParams = true;
                for (int j = 0; j < parameterTypes.length; ++j) {
                    Class<?> a = parameterTypes[j];
                    Class<?> b = curParameterTypes[j];
                    if (ClassUtil.isSubclass(a, b.getName())) continue;
                    correctParams = false;
                    break;
                }
                if (!correctParams) continue;
                return method.invoke(this._object, methodHandler.getArguments());
            }
            throw noSuchMethodException;
        }
    }
}

