package com.beust.ah;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Set;

class Pair<T, V> {
    AbstractMap.SimpleEntry<T, V> entry;

    public Pair(T t, V v) {
        this.entry = new AbstractMap.SimpleEntry<>(t, v);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Pair<?, ?>)) {
            return false;
        }
        Pair<?, ?> otherPair = (Pair<?, ?>) o;
        return this.entry.equals(otherPair.entry);
    }

    @Override
    public int hashCode() {
        return this.entry.hashCode();
    }
}

public class A {
    public static void main(String[] args) {
        int n = 40_000;
        Set<Pair<Integer, Integer>> set = new HashSet<>();
        long start = System.currentTimeMillis();
        for (int i = 0; i < n; i++) {
            set.add(new Pair(i, i));
        }
        System.out.printf("Total time to add %d entries: %d ms", n, System.currentTimeMillis() - start);
    }

}
