/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import javax.sql.DataSource;

@OSGiBeanProperties(service={InfrastructureUtil.class})
public class InfrastructureUtil {
    private static DataSource _dataSource;
    private static final DefaultNoticeableFuture<Object> _sessionFactoryDefaultNoticeableFuture;
    private static final DefaultNoticeableFuture<Object> _transactionManagerDefaultNoticeableFuture;

    public static DataSource getDataSource() {
        return _dataSource;
    }

    public static Object getSessionFactory() {
        try {
            return _sessionFactoryDefaultNoticeableFuture.get();
        }
        catch (Exception exception) {
            return ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public static Object getTransactionManager() {
        try {
            return _transactionManagerDefaultNoticeableFuture.get();
        }
        catch (Exception exception) {
            return ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public static void setDataSource(DataSource dataSource) {
        _dataSource = dataSource;
    }

    public static void setSessionFactory(Object sessionFactory) {
        _sessionFactoryDefaultNoticeableFuture.set(sessionFactory);
    }

    public static void setTransactionManager(Object transactionManager) {
        _transactionManagerDefaultNoticeableFuture.set(transactionManager);
    }

    static {
        _sessionFactoryDefaultNoticeableFuture = new DefaultNoticeableFuture();
        _transactionManagerDefaultNoticeableFuture = new DefaultNoticeableFuture();
    }
}

