/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class UriInfoUtil {
    private static volatile Field _uriBuilderHostField;

    public static String getBasePath(UriInfo uriInfo) {
        return String.valueOf(UriInfoUtil.getBaseUriBuilder(uriInfo).build(new Object[0]));
    }

    public static UriBuilder getBaseUriBuilder(HttpServletRequest httpServletRequest, UriInfo uriInfo) {
        UriBuilder uriBuilder = UriInfoUtil.getBaseUriBuilder(uriInfo);
        uriBuilder.host(PortalUtil.getForwardedHost(httpServletRequest));
        int port = PortalUtil.getForwardedPort(httpServletRequest);
        boolean secure = PortalUtil.isSecure(httpServletRequest);
        if (port != 80 && !secure || port != 443 && secure) {
            uriBuilder.port(port);
        } else {
            uriBuilder.port(-1);
        }
        if (secure) {
            uriBuilder.scheme("https");
        }
        return uriBuilder;
    }

    public static UriBuilder getBaseUriBuilder(String applicationPath, UriInfo uriInfo) {
        String basePath = UriInfoUtil.getBasePath(uriInfo);
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        if ((basePath = basePath.substring(0, basePath.lastIndexOf("/") + 1)).endsWith("/c/")) {
            basePath = StringUtil.removeLast(basePath, "c/");
        }
        basePath = basePath + applicationPath;
        return UriBuilder.fromPath((String)basePath);
    }

    public static UriBuilder getBaseUriBuilder(UriInfo uriInfo) {
        return UriInfoUtil._updateUriBuilder(uriInfo.getBaseUriBuilder());
    }

    private static String _getHost(UriBuilder uriBuilder) {
        try {
            if (_uriBuilderHostField == null) {
                _uriBuilderHostField = ReflectionUtil.getDeclaredField(uriBuilder.getClass(), (String)"host");
            }
            return (String)_uriBuilderHostField.get(uriBuilder);
        }
        catch (Exception exception) {
            return (String)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    private static boolean _isHttpsEnabled() {
        return "https".equals(PropsUtil.get("portal.instance.protocol")) || "https".equals(PropsUtil.get("web.server.protocol"));
    }

    private static UriBuilder _updateUriBuilder(UriBuilder uriBuilder) {
        if (!Validator.isBlank(PortalUtil.getPathContext())) {
            URI uri = uriBuilder.build(new Object[0]);
            uriBuilder.replacePath(PortalUtil.getPathContext(uri.getPath()));
        }
        if (Validator.isNotNull(UriInfoUtil._getHost(uriBuilder)) && UriInfoUtil._isHttpsEnabled()) {
            uriBuilder.scheme("https");
        }
        return uriBuilder;
    }
}

