/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;

public class GroupUtil {
    private static final Log _log = LogFactoryUtil.getLog(GroupUtil.class);

    public static String getAssetLibraryKey(Group group) {
        if (group.isDepot()) {
            return group.getGroupKey();
        }
        return null;
    }

    public static Long getDepotGroupId(String assetLibraryKey, long companyId, DepotEntryLocalService depotEntryLocalService, GroupLocalService groupLocalService) {
        Group group = groupLocalService.fetchGroup(companyId, assetLibraryKey);
        if (group == null) {
            try {
                DepotEntry depotEntry = depotEntryLocalService.fetchDepotEntry(GetterUtil.getLong(assetLibraryKey));
                if (depotEntry == null) {
                    return null;
                }
                group = depotEntry.getGroup();
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug(portalException);
                }
                return null;
            }
        }
        if (GroupUtil._checkGroup(group)) {
            return group.getGroupId();
        }
        return null;
    }

    public static Long getGroupId(long companyId, String siteKey, GroupLocalService groupLocalService) {
        Group group = groupLocalService.fetchGroup(companyId, siteKey);
        if (group == null) {
            group = groupLocalService.fetchGroup(GetterUtil.getLong(siteKey));
        }
        if (GroupUtil._checkGroup(group)) {
            return group.getGroupId();
        }
        return null;
    }

    public static Long getSiteId(Group group) {
        if (group.isDepot()) {
            return null;
        }
        return group.getGroupId();
    }

    private static boolean _checkGroup(Group group) {
        return GroupUtil._isDepotOrSite(group) || group != null && GroupUtil._isDepotOrSite(group.getLiveGroup());
    }

    private static boolean _isDepotOrSite(Group group) {
        return group != null && (group.isDepot() || group.isSite());
    }
}

