/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.jackson.databind;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.vulcan.jaxrs.serializer.JSONArrayStdSerializer;
import com.liferay.portal.vulcan.jaxrs.serializer.JSONObjectStdSerializer;
import com.liferay.portal.vulcan.jaxrs.serializer.UnsafeSupplierJsonSerializer;
import java.text.DateFormat;

public class ObjectMapperProviderUtil {
    private static volatile ObjectMapper _batchEngineObjectMapper;
    private static Integer _jsonStringMaxLength;
    private static volatile ObjectMapper _objectMapper;

    public static ObjectMapper getBatchEngineObjectMapper() {
        if (_batchEngineObjectMapper != null && _jsonStringMaxLength != null && _jsonStringMaxLength.equals(PropsValues.JSON_STRING_MAX_LENGTH)) {
            return _batchEngineObjectMapper;
        }
        _jsonStringMaxLength = PropsValues.JSON_STRING_MAX_LENGTH;
        _batchEngineObjectMapper = new ObjectMapper(ObjectMapperProviderUtil._getJsonFactory(_jsonStringMaxLength)){
            {
                this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
                this.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
                this.registerModule((Module)new SimpleModule(){
                    {
                        this.addSerializer(UnsafeSupplier.class, new UnsafeSupplierJsonSerializer());
                    }
                });
                this.setDateFormat((DateFormat)new ISO8601DateFormat());
                this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            }
        };
        return _batchEngineObjectMapper;
    }

    public static ObjectMapper getObjectMapper() {
        if (_objectMapper != null && _jsonStringMaxLength != null && _jsonStringMaxLength.equals(PropsValues.JSON_STRING_MAX_LENGTH)) {
            return _objectMapper;
        }
        _jsonStringMaxLength = PropsValues.JSON_STRING_MAX_LENGTH;
        _objectMapper = new ObjectMapper(ObjectMapperProviderUtil._getJsonFactory(_jsonStringMaxLength)){
            {
                this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
                this.enable(SerializationFeature.INDENT_OUTPUT);
                this.registerModule((Module)new SimpleModule(){
                    {
                        this.addSerializer(JSONArray.class, (JsonSerializer)new JSONArrayStdSerializer(JSONArray.class));
                        this.addSerializer(JSONObject.class, (JsonSerializer)new JSONObjectStdSerializer(JSONObject.class));
                        this.addSerializer(UnsafeSupplier.class, new UnsafeSupplierJsonSerializer());
                    }
                });
                this.setDateFormat((DateFormat)new ISO8601DateFormat());
                this.setFilterProvider((FilterProvider)new SimpleFilterProvider(){
                    {
                        this.addFilter("Liferay.Vulcan", SimpleBeanPropertyFilter.serializeAll());
                    }
                });
                this.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
            }
        };
        return _objectMapper;
    }

    private static JsonFactory _getJsonFactory(int jsonStringMaxLength) {
        return ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(jsonStringMaxLength).build())).build();
    }
}

