/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.permission;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourceActionModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.vulcan.permission.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.BadRequestException;

public class PermissionUtil {
    private static final Log _log = LogFactoryUtil.getLog(PermissionUtil.class);

    public static void checkPermission(String actionId, GroupLocalService groupLocalService, String resourceName, long resourceId, Long siteId) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        Group group = groupLocalService.fetchGroup(siteId.longValue());
        if (group != null && group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (!permissionChecker.hasPermission(group, resourceName, resourceId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, resourceName, siteId.longValue(), new String[]{actionId});
        }
    }

    public static Collection<Permission> getPermissions(long companyId, List<ResourceAction> resourceActions, long resourceId, String resourceName, String[] roleNames) throws Exception {
        HashMap<String, 1> permissions = new HashMap<String, 1>();
        int count = ResourcePermissionLocalServiceUtil.getResourcePermissionsCount((long)companyId, (String)resourceName, (int)4, (String)String.valueOf(resourceId));
        if (count == 0) {
            ResourceLocalServiceUtil.addResources((long)companyId, (long)resourceId, (long)0L, (String)resourceName, (String)String.valueOf(resourceId), (boolean)false, (boolean)true, (boolean)true);
        }
        List actionIds = TransformUtil.transform(resourceActions, ResourceActionModel::getActionId);
        HashSet<Role> roles = new HashSet<Role>();
        HashSet resourcePermissions = new HashSet();
        resourcePermissions.addAll(ResourcePermissionLocalServiceUtil.getResourcePermissions((long)companyId, (String)resourceName, (int)1, (String)String.valueOf(companyId)));
        resourcePermissions.addAll(ResourcePermissionLocalServiceUtil.getResourcePermissions((long)companyId, (String)resourceName, (int)2, (String)String.valueOf(GroupThreadLocal.getGroupId())));
        resourcePermissions.addAll(ResourcePermissionLocalServiceUtil.getResourcePermissions((long)companyId, (String)resourceName, (int)3, (String)"0"));
        resourcePermissions.addAll(ResourcePermissionLocalServiceUtil.getResourcePermissions((long)companyId, (String)resourceName, (int)4, (String)String.valueOf(resourceId)));
        if (roleNames != null) {
            for (String roleName : roleNames) {
                roles.add(RoleLocalServiceUtil.getRole((long)companyId, (String)roleName));
            }
        } else {
            for (ResourcePermission resourcePermission2 : resourcePermissions) {
                roles.add(RoleLocalServiceUtil.getRole((long)resourcePermission2.getRoleId()));
            }
        }
        for (final Role role : roles) {
            final HashSet actionsIdsSet = new HashSet();
            for (Resource resource : TransformUtil.transform(resourcePermissions, resourcePermission -> ResourceLocalServiceUtil.getResource((long)resourcePermission.getCompanyId(), (String)resourcePermission.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey()))) {
                actionsIdsSet.addAll(ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)resource.getCompanyId(), (String)resource.getName(), (int)1, (String)String.valueOf(resource.getCompanyId()), (long)role.getRoleId(), (Collection)actionIds));
                actionsIdsSet.addAll(ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)resource.getCompanyId(), (String)resource.getName(), (int)2, (String)String.valueOf(GroupThreadLocal.getGroupId()), (long)role.getRoleId(), (Collection)actionIds));
                actionsIdsSet.addAll(ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)resource.getCompanyId(), (String)resource.getName(), (int)3, (String)"0", (long)role.getRoleId(), (Collection)actionIds));
                actionsIdsSet.addAll(ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)resource.getCompanyId(), (String)resource.getName(), (int)resource.getScope(), (String)resource.getPrimKey(), (long)role.getRoleId(), (Collection)actionIds));
            }
            if (actionsIdsSet.isEmpty()) continue;
            permissions.put(role.getName(), new Permission(){
                {
                    this.actionIds = actionsIdsSet.toArray(new String[0]);
                    this.roleName = role.getName();
                }
            });
        }
        return permissions.values();
    }

    public static List<ResourcePermission> getResourcePermissions(long companyId, long resourceId, String resourceName, ResourcePermissionLocalService resourcePermissionLocalService) throws PortalException {
        PermissionUtil._checkResources(companyId, resourceId, resourceName, resourcePermissionLocalService);
        return resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId));
    }

    public static List<Role> getRoles(Company company, RoleLocalService roleLocalService, String[] roleNames) throws PortalException {
        ArrayList<Role> roles = new ArrayList<Role>();
        ArrayList<String> invalidRoleNames = new ArrayList<String>();
        for (String roleName : roleNames) {
            try {
                roles.add(roleLocalService.getRole(company.getCompanyId(), roleName));
            }
            catch (NoSuchRoleException noSuchRoleException) {
                if (_log.isDebugEnabled()) {
                    _log.debug(roleName, noSuchRoleException);
                }
                invalidRoleNames.add(roleName);
            }
        }
        if (!invalidRoleNames.isEmpty()) {
            throw new BadRequestException("Invalid roles: " + ArrayUtil.toStringArray(invalidRoleNames));
        }
        return roles;
    }

    public static Permission toPermission(List<ResourceAction> resourceActions, ResourcePermission resourcePermission, final Role role) {
        final HashSet<String> actionsIdsSet = new HashSet<String>();
        long actionIds = resourcePermission.getActionIds();
        for (ResourceAction resourceAction : resourceActions) {
            long bitwiseValue = resourceAction.getBitwiseValue();
            if ((actionIds & bitwiseValue) != bitwiseValue) continue;
            actionsIdsSet.add(resourceAction.getActionId());
        }
        return new Permission(){
            {
                this.actionIds = actionsIdsSet.toArray(new String[0]);
                this.roleName = role.getName();
            }
        };
    }

    public static Permission toPermission(Long companyId, Long id, List<ResourceAction> resourceActions, String resourceName, ResourcePermissionLocalService resourcePermissionLocalService, Role role) throws PortalException {
        PermissionUtil._checkResources(companyId, id, resourceName, resourcePermissionLocalService);
        ResourcePermission resourcePermission = resourcePermissionLocalService.fetchResourcePermission(companyId.longValue(), resourceName, 4, String.valueOf(id), role.getRoleId());
        if (resourcePermission == null) {
            return null;
        }
        return PermissionUtil.toPermission(resourceActions, resourcePermission, role);
    }

    private static void _checkResources(long companyId, long resourceId, String resourceName, ResourcePermissionLocalService resourcePermissionLocalService) throws PortalException {
        int count = resourcePermissionLocalService.getResourcePermissionsCount(companyId, resourceName, 4, String.valueOf(resourceId));
        if (count == 0) {
            ResourceLocalServiceUtil.addResources((long)companyId, (long)resourceId, (long)0L, (String)resourceName, (String)String.valueOf(resourceId), (boolean)false, (boolean)true, (boolean)true);
        }
    }
}

