/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.rest.builder.internal.freemarker;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.rest.builder.internal.util.FileUtil;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;

public class FreeMarker {
    private static final Configuration _configuration = new Configuration(Configuration.VERSION_2_3_32);

    public FreeMarker() {
        _configuration.setNumberFormat("computer");
        DefaultObjectWrapperBuilder defaultObjectWrapperBuilder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_32);
        _configuration.setObjectWrapper((ObjectWrapper)defaultObjectWrapperBuilder.build());
        ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(FreeMarker.class, "/");
        _configuration.setTemplateLoader((TemplateLoader)classTemplateLoader);
        _configuration.setTemplateUpdateDelayMilliseconds(Long.MAX_VALUE);
    }

    public String processTemplate(File copyrightFile, String copyrightYear, String name, Map<String, Object> context) throws Exception {
        Template template = _configuration.getTemplate(name);
        StringWriter stringWriter = new StringWriter();
        template.process(context, (Writer)stringWriter);
        String content = String.valueOf(stringWriter.getBuffer());
        if (copyrightFile != null && copyrightFile.exists()) {
            String copyright = FileUtil.read(copyrightFile);
            copyright = copyright.replaceFirst(Pattern.quote("{$year}"), copyrightYear);
            content = copyright + "\n\n" + content;
        }
        return StringUtil.replace(content, "\r\n", "\n");
    }
}

