/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.tools.java.parser.BaseJavaTerm;
import com.liferay.portal.tools.java.parser.JavaAnnotation;
import com.liferay.portal.tools.java.parser.JavaExpression;
import com.liferay.portal.tools.java.parser.JavaSimpleValue;
import com.liferay.portal.tools.java.parser.JavaType;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaVariableDefinition
extends BaseJavaTerm {
    private final List<JavaAnnotation> _javaAnnotations;
    private JavaType _javaType;
    private final List<JavaSimpleValue> _modifiers;
    private final Map<JavaSimpleValue, JavaExpression> _variableMap = new LinkedHashMap<JavaSimpleValue, JavaExpression>();

    public JavaVariableDefinition(List<JavaAnnotation> javaAnnotations, List<JavaSimpleValue> modifiers) {
        this._javaAnnotations = javaAnnotations;
        this._modifiers = modifiers;
    }

    public void addVariable(String name) {
        this.addVariable(name, null);
    }

    public void addVariable(String name, JavaExpression assignValueJavaExpression) {
        this._variableMap.put(new JavaSimpleValue(name), assignValueJavaExpression);
    }

    public JavaExpression getAssignValueJavaExpression() {
        Set<Map.Entry<JavaSimpleValue, JavaExpression>> set = this._variableMap.entrySet();
        Iterator<Map.Entry<JavaSimpleValue, JavaExpression>> iterator = set.iterator();
        Map.Entry<JavaSimpleValue, JavaExpression> entry = iterator.next();
        return entry.getValue();
    }

    public void setJavaType(JavaType javaType) {
        this._javaType = javaType;
    }

    @Override
    public String toString(String indent, String prefix, String suffix, int maxLineLength) {
        StringBundler sb = new StringBundler();
        for (int i = 0; i < this._javaAnnotations.size(); ++i) {
            if (i == 0) {
                this.appendNewLine(sb, this._javaAnnotations.get(i), indent, prefix, "", maxLineLength);
                prefix = "";
                continue;
            }
            this.appendNewLine(sb, this._javaAnnotations.get(i), indent, maxLineLength);
        }
        if (sb.index() > 0) {
            sb.append("\n");
        }
        sb.append(indent);
        indent = "\t" + indent;
        if (!this._modifiers.isEmpty()) {
            indent = this.append(sb, this._modifiers, " ", indent, prefix, " ", maxLineLength);
            prefix = "";
        }
        if (this._javaType != null) {
            indent = this.append(sb, this._javaType, indent, prefix, " ", maxLineLength, false);
            prefix = "";
        }
        String startIndent = indent;
        Set<Map.Entry<JavaSimpleValue, JavaExpression>> set = this._variableMap.entrySet();
        Iterator<Map.Entry<JavaSimpleValue, JavaExpression>> iterator = set.iterator();
        while (true) {
            Map.Entry<JavaSimpleValue, JavaExpression> entry = iterator.next();
            JavaExpression assignValueJavaExpression = entry.getValue();
            JavaSimpleValue name = entry.getKey();
            if (!iterator.hasNext()) {
                if (assignValueJavaExpression != null) {
                    indent = this.append(sb, name, startIndent, prefix, " = ", maxLineLength);
                    this.appendAssignValue(sb, assignValueJavaExpression, indent, suffix, maxLineLength, false);
                    break;
                }
                this.append(sb, name, startIndent, "", suffix, maxLineLength);
                break;
            }
            if (assignValueJavaExpression != null) {
                indent = this.append(sb, name, startIndent, prefix, " = ", maxLineLength);
                this.appendAssignValue(sb, assignValueJavaExpression, indent, ", ", maxLineLength, false);
                continue;
            }
            this.append(sb, name, startIndent, "", ", ", maxLineLength);
        }
        return sb.toString();
    }
}

