/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin.deployment.extension;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.deploy.BaseDeployer;
import com.liferay.portal.tools.deploy.extension.DeploymentExtension;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;

public class WebSphereDeploymentExtension
implements DeploymentExtension {
    private static final Log _log = LogFactoryUtil.getLog(WebSphereDeploymentExtension.class);

    public void copyXmls(BaseDeployer baseDeployer, File srcFile) throws Exception {
        baseDeployer.copyDependencyXml("ibm-web-ext.xmi", srcFile + "/WEB-INF");
    }

    public String getServerId() {
        return "websphere";
    }

    public void postDeploy(String destDir, String deployDir) throws Exception {
        String pluginServletContextName;
        if (Validator.isNull((String)PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_MANAGER_QUERY)) {
            if (_log.isInfoEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("Do not install the plugin with wsadmin since the ");
                sb.append("property \"");
                sb.append("auto.deploy.websphere.wsadmin.app.manager.query");
                sb.append("\"is not configured");
                _log.info((Object)sb.toString());
            }
            return;
        }
        String wsadminContent = FileUtil.read((String)DeployUtil.getResourcePath((String)"wsadmin.py"));
        String adminAppListOptions = PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_MANAGER_LIST_OPTIONS;
        if (Validator.isNotNull((String)adminAppListOptions)) {
            adminAppListOptions = "'" + adminAppListOptions + "'";
        }
        wsadminContent = StringUtil.replace((String)wsadminContent, (String[])new String[]{"${auto.deploy.websphere.wsadmin.app.manager.install.options}", "${auto.deploy.websphere.wsadmin.app.manager.list.options}", "${auto.deploy.websphere.wsadmin.app.manager.query}", "${auto.deploy.websphere.wsadmin.app.manager.update.options}"}, (String[])new String[]{PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_MANAGER_INSTALL_OPTIONS, adminAppListOptions, PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_MANAGER_QUERY, PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_MANAGER_UPDATE_OPTIONS});
        String pluginApplicationName = pluginServletContextName = deployDir.substring(0, deployDir.length() - 4);
        if (Validator.isNotNull((String)PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_NAME_SUFFIX)) {
            pluginApplicationName = pluginApplicationName + PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_NAME_SUFFIX;
        }
        wsadminContent = StringUtil.replace((String)wsadminContent, (String[])new String[]{"${auto.deploy.dest.dir}", "${auto.deploy.websphere.wsadmin.app.name}", "${plugin.servlet.context.name}"}, (String[])new String[]{destDir, pluginApplicationName, pluginServletContextName});
        String wsadminFileName = FileUtil.createTempFileName((String)"py");
        FileUtil.write((String)wsadminFileName, (String)wsadminContent);
        String webSphereHome = System.getenv("WAS_HOME");
        ArrayList<String> commands = new ArrayList<String>();
        if (OSDetector.isWindows()) {
            commands.add(webSphereHome + "\\bin\\wsadmin.bat");
        } else {
            commands.add(webSphereHome + "/bin/wsadmin.sh");
        }
        if (Validator.isNotNull((String)PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_PROPERTIES_FILE)) {
            commands.add("-p");
            commands.add(PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_PROPERTIES_FILE);
        }
        commands.add("-f");
        commands.add(wsadminFileName);
        if (_log.isInfoEnabled()) {
            StringBundler sb = new StringBundler(commands.size() * 2 + 1);
            sb.append("Installing plugin by executing");
            for (String command : commands) {
                sb.append(" ");
                sb.append(command);
            }
            _log.info((Object)sb.toString());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.redirectErrorStream(true);
        if (_log.isInfoEnabled()) {
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            String output = StringUtil.read((InputStream)inputStream);
            for (String line : StringUtil.split((String)output, (char)'\n')) {
                _log.info((Object)("Process output: " + line));
            }
            try {
                int exitValue = process.exitValue();
                if (exitValue == 0) {
                    _log.info((Object)("Successfully executed command with an exit value of " + exitValue));
                } else {
                    _log.info((Object)("Unsuccessfully executed command with an exit value of " + exitValue));
                }
            }
            catch (IllegalThreadStateException itse) {
                _log.info((Object)"Process did not terminate");
            }
        }
        FileUtil.delete((String)wsadminFileName);
    }
}

