/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.debug.spring.extender.internal;

import com.liferay.petra.string.StringBundler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UnavailableComponentUtil {
    public static String scanUnavailableComponents() {
        StringBundler sb = new StringBundler();
        for (DependencyManager dependencyManager : DependencyManager.getDependencyManagers()) {
            HashMap<ComponentDeclaration, List> unavailableComponentDeclarations = new HashMap<ComponentDeclaration, List>();
            for (ComponentDeclaration componentDeclaration : dependencyManager.getComponents()) {
                if (componentDeclaration.getState() != 0) continue;
                List componentDependencyDeclarations = unavailableComponentDeclarations.computeIfAbsent(componentDeclaration, key -> new ArrayList());
                for (ComponentDependencyDeclaration componentDependencyDeclaration : componentDeclaration.getComponentDependencies()) {
                    if (componentDependencyDeclaration.getState() != 2) continue;
                    componentDependencyDeclarations.add(componentDependencyDeclaration);
                }
            }
            if (unavailableComponentDeclarations.isEmpty()) continue;
            BundleContext bundleContext = dependencyManager.getBundleContext();
            Bundle bundle = bundleContext.getBundle();
            sb.append("\nBundle {id: ");
            sb.append(bundle.getBundleId());
            sb.append(", name: ");
            sb.append(bundle.getSymbolicName());
            sb.append(", version: ");
            sb.append((Object)bundle.getVersion());
            sb.append("}.\n");
            for (Map.Entry entry : unavailableComponentDeclarations.entrySet()) {
                sb.append("\tComponent with ID ");
                ComponentDeclaration componentDeclaration = (ComponentDeclaration)entry.getKey();
                sb.append(componentDeclaration.getId());
                sb.append(" is unavailable due to missing required ");
                sb.append("dependencies:\n\t\t");
                for (ComponentDependencyDeclaration componentDependencyDeclaration : (List)entry.getValue()) {
                    sb.append((Object)componentDependencyDeclaration);
                    sb.append("\n\t\t");
                }
                sb.setIndex(sb.index() - 1);
            }
        }
        return sb.toString();
    }
}

