/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.debug.spring.extender.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.osgi.debug.spring.extender.internal.UnavailableComponentUtil;
import com.liferay.portal.osgi.debug.spring.extender.internal.configuration.UnavailableComponentScannerConfiguration;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.portal.osgi.debug.spring.extender.internal.configuration.UnavailableComponentScannerConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={})
public class UnavailableComponentScanner {
    private static final Log _log = LogFactoryUtil.getLog(UnavailableComponentScanner.class);
    private Thread _unavailableComponentScanningThread;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        UnavailableComponentScannerConfiguration unavailableComponentScannerConfiguration = (UnavailableComponentScannerConfiguration)ConfigurableUtil.createConfigurable(UnavailableComponentScannerConfiguration.class, properties);
        long scanningInterval = unavailableComponentScannerConfiguration.unavailableComponentScanningInterval();
        if (scanningInterval > 0L) {
            this._unavailableComponentScanningThread = new UnavailableComponentScanningThread(scanningInterval * 1000L);
            this._unavailableComponentScanningThread.start();
        }
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) throws InterruptedException {
        if (this._unavailableComponentScanningThread != null) {
            this._unavailableComponentScanningThread.interrupt();
            this._unavailableComponentScanningThread.join();
        }
    }

    private static class UnavailableComponentScanningThread
    extends Thread {
        private final long _scanningInterval;

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(this._scanningInterval);
                    String scanResult = UnavailableComponentUtil.scanUnavailableComponents();
                    if (scanResult.isEmpty()) {
                        if (!_log.isInfoEnabled()) continue;
                        _log.info((Object)"All Spring extender dependency manager components are registered");
                        continue;
                    }
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)scanResult);
                }
            }
            catch (InterruptedException ie) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Stopped scanning for unavailable components");
                }
                return;
            }
        }

        private UnavailableComponentScanningThread(long scanningInterval) {
            this._scanningInterval = scanningInterval;
            this.setDaemon(true);
            this.setName("Spring Extender Unavailable Component Scanner");
        }
    }
}

