/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.osgi.debug.missing.component.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.bundle.blacklist.BundleBlacklistManager;
import com.liferay.portal.kernel.module.util.BundleUtil;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;

/**
 * @author Matthew Tambara
 */
public class MissingComponentUtil {

	public static String scan(
		BundleContext bundleContext,
		ServiceComponentRuntime serviceComponentRuntime) {

		Bundle blacklistBundle = BundleUtil.getBundle(
			bundleContext, "com.liferay.portal.bundle.blacklist.impl");

		ServiceReference<BundleBlacklistManager> serviceReference =
			bundleContext.getServiceReference(BundleBlacklistManager.class);

		if (serviceReference != null) {
			return StringPool.BLANK;
		}

		ComponentDescriptionDTO componentDescriptionDTO =
			serviceComponentRuntime.getComponentDescriptionDTO(
				blacklistBundle,
				"com.liferay.portal.bundle.blacklist.internal." +
					"BundleBlacklistManagerImpl");

		StringBundler sb = new StringBundler();

		if (componentDescriptionDTO == null) {
			sb.append("Blacklist manager is not available.\n");
			sb.append("Available components: ");
			sb.append(blacklistBundle.getSymbolicName());

			for (ComponentDescriptionDTO bundleComponentDescriptionDTO :
					serviceComponentRuntime.getComponentDescriptionDTOs(
						blacklistBundle)) {

				_describeComponent(
					bundleComponentDescriptionDTO, sb, serviceComponentRuntime);
			}

			return sb.toString();
		}

		_describeComponent(
			componentDescriptionDTO, sb, serviceComponentRuntime);

		return sb.toString();
	}

	private static void _describeComponent(
		ComponentDescriptionDTO componentDescriptionDTO, StringBundler sb,
		ServiceComponentRuntime serviceComponentRuntime) {

		sb.append("@@@@Name: ");
		sb.append(componentDescriptionDTO.name);
		sb.append("\n@@Instances:");

		for (ComponentConfigurationDTO componentConfigurationDTO :
				serviceComponentRuntime.getComponentConfigurationDTOs(
					componentDescriptionDTO)) {

			sb.append("\nid: ");
			sb.append(componentConfigurationDTO.id);
			sb.append("\nState: ");
			sb.append(componentConfigurationDTO.state);
			sb.append("\n Satisfied references: ");

			for (SatisfiedReferenceDTO satisfiedReference :
					componentConfigurationDTO.satisfiedReferences) {

				sb.append("\n\tName: ");
				sb.append(satisfiedReference.name);
			}

			sb.append("\nUnsatisfied references: ");

			for (UnsatisfiedReferenceDTO unsatisfiedReference :
					componentConfigurationDTO.unsatisfiedReferences) {

				sb.append("\n\tName: ");
				sb.append(unsatisfiedReference.name);
			}
		}
	}

}