/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.osgi.debug.missing.component.internal.osgi.commands;

import com.liferay.portal.osgi.debug.missing.component.internal.MissingComponentUtil;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;

/**
 * @author Matthew Tambara
 */
@Component(
	immediate = true,
	property = {
		"osgi.command.function=missingComponent", "osgi.command.scope=ds"
	},
	service = MissingComponentOSGiCommands.class
)
public class MissingComponentOSGiCommands {

	public void missingComponent() {
		System.out.println(
			MissingComponentUtil.scan(
				_bundleContext, _serviceComponentRuntime));
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_bundleContext = bundleContext;
	}

	private BundleContext _bundleContext;

	@Reference
	private ServiceComponentRuntime _serviceComponentRuntime;

}