/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.debug.declarative.service.internal;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;

public class SoftCircularDependencyUtil {
    private static final Log _log = LogFactoryUtil.getLog(SoftCircularDependencyUtil.class);
    private static final Comparator<ComponentDescriptionDTO> _comparator = (componentDescriptionDTO1, componentDescriptionDTO2) -> {
        String name = componentDescriptionDTO1.name;
        return name.compareTo(componentDescriptionDTO2.name);
    };

    public static String listSoftCircularDependencies(ServiceComponentRuntime serviceComponentRuntime, BundleContext bundleContext) {
        Collection componentDescriptionDTOs = serviceComponentRuntime.getComponentDescriptionDTOs(bundleContext.getBundles());
        Map<ComponentDescriptionKey, ComponentDescriptionDTO> componentDescriptionDTOIndexMap = SoftCircularDependencyUtil._toIndexMap(componentDescriptionDTOs);
        Map<ComponentDescriptionDTO, List<Dependency>> closureNavigationMap = SoftCircularDependencyUtil._createClosureNavigationMap(bundleContext, componentDescriptionDTOs, componentDescriptionDTOIndexMap);
        Set<List<Dependency>> circularDependencies = SoftCircularDependencyUtil._findSoftCircularDependencies(closureNavigationMap);
        StringBundler sb = new StringBundler();
        for (List<Dependency> dependencies : circularDependencies) {
            sb.append("{");
            for (Dependency dependency : dependencies) {
                dependency.appendToChain(sb);
            }
            sb.append("(circular reference)}\n");
        }
        return sb.toString();
    }

    private static Map<ComponentDescriptionDTO, List<Dependency>> _createClosureNavigationMap(BundleContext bundleContext, Collection<ComponentDescriptionDTO> componentDescriptionDTOs, Map<ComponentDescriptionKey, ComponentDescriptionDTO> componentDescriptionDTOIndexMap) {
        int size;
        HashSet<Dependency> fullyVisitedDependencies = new HashSet<Dependency>();
        TreeMap<ComponentDescriptionDTO, List<Dependency>> closureNavigationMap = new TreeMap<ComponentDescriptionDTO, List<Dependency>>(_comparator);
        do {
            size = componentDescriptionDTOs.size();
            Iterator<ComponentDescriptionDTO> iterator = componentDescriptionDTOs.iterator();
            while (iterator.hasNext()) {
                ComponentDescriptionDTO fromComponentDescriptionDTO = iterator.next();
                LinkedList<Dependency> dependencies = new LinkedList<Dependency>();
                for (ReferenceDTO referenceDTO : fromComponentDescriptionDTO.references) {
                    ServiceReference[] serviceReferences = null;
                    try {
                        serviceReferences = bundleContext.getServiceReferences(referenceDTO.interfaceName, referenceDTO.target);
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {
                        String reference = referenceDTO.bind;
                        if (reference == null) {
                            reference = referenceDTO.field;
                        }
                        _log.error((Object)StringBundler.concat((String[])new String[]{"Invalid filter \"", referenceDTO.target, "\" from", fromComponentDescriptionDTO.implementationClass, "[", reference, "]"}), (Throwable)invalidSyntaxException);
                        continue;
                    }
                    if (serviceReferences == null) continue;
                    for (ServiceReference serviceReference : serviceReferences) {
                        Object service = bundleContext.getService(serviceReference);
                        if (service == null) continue;
                        Bundle bundle = serviceReference.getBundle();
                        Class<?> clazz = service.getClass();
                        bundleContext.ungetService(serviceReference);
                        ComponentDescriptionDTO toComponentDescriptionDTO = componentDescriptionDTOIndexMap.get(new ComponentDescriptionKey(bundle.getBundleId(), clazz.getName()));
                        if (toComponentDescriptionDTO == null) continue;
                        dependencies.add(new Dependency(fromComponentDescriptionDTO, toComponentDescriptionDTO, referenceDTO));
                    }
                }
                if (fullyVisitedDependencies.containsAll(dependencies)) {
                    fullyVisitedDependencies.add(new Dependency(null, fromComponentDescriptionDTO, null));
                    iterator.remove();
                    closureNavigationMap.remove(fromComponentDescriptionDTO);
                    continue;
                }
                closureNavigationMap.put(fromComponentDescriptionDTO, dependencies);
            }
        } while (size != componentDescriptionDTOs.size());
        for (List dependencies : closureNavigationMap.values()) {
            Iterator iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                Dependency dependency = (Dependency)iterator.next();
                if (closureNavigationMap.containsKey(dependency.getToComponentDescriptionDTO())) continue;
                iterator.remove();
            }
        }
        return closureNavigationMap;
    }

    private static Set<List<Dependency>> _findSoftCircularDependencies(Map<ComponentDescriptionDTO, List<Dependency>> closureNavigationMap) {
        LinkedHashSet<List<Dependency>> softCircularDependencies = new LinkedHashSet<List<Dependency>>();
        HashSet<Dependency> excludedDependencies = new HashSet<Dependency>();
        for (Map.Entry<ComponentDescriptionDTO, List<Dependency>> entry : closureNavigationMap.entrySet()) {
            Dependency startDependency = new Dependency(null, entry.getKey(), null);
            if (excludedDependencies.contains(startDependency)) continue;
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            dependencies.add(startDependency);
            LinkedList backTrace = new LinkedList();
            backTrace.push(dependencies);
            block1: while (!backTrace.isEmpty()) {
                LinkedList<Dependency> trace = new LinkedList<Dependency>();
                for (List list : backTrace) {
                    trace.addFirst((Dependency)list.get(0));
                }
                Dependency dependency = (Dependency)trace.getLast();
                ArrayList arrayList = new ArrayList(closureNavigationMap.get(dependency.getToComponentDescriptionDTO()));
                arrayList.removeAll(excludedDependencies);
                if (arrayList.isEmpty()) {
                    List topDependencies = null;
                    while ((topDependencies = (List)backTrace.poll()) != null) {
                        if (topDependencies.size() <= 1) continue;
                        backTrace.push(topDependencies.subList(1, topDependencies.size()));
                        continue block1;
                    }
                    continue;
                }
                dependency = (Dependency)arrayList.get(0);
                int index = trace.indexOf(dependency);
                if (index == -1) {
                    backTrace.push(arrayList);
                    continue;
                }
                if (arrayList.size() > 1) {
                    backTrace.push(arrayList.subList(1, arrayList.size()));
                } else {
                    List topDependencies = null;
                    while ((topDependencies = (List)backTrace.poll()) != null) {
                        if (topDependencies.size() <= 1) continue;
                        backTrace.push(topDependencies.subList(1, topDependencies.size()));
                        break;
                    }
                }
                List<Dependency> newTrace = trace.subList(index + 1, trace.size());
                newTrace.add(dependency);
                excludedDependencies.addAll(newTrace);
                if (newTrace.size() <= 1) continue;
                softCircularDependencies.add(newTrace);
            }
        }
        return softCircularDependencies;
    }

    private static Map<ComponentDescriptionKey, ComponentDescriptionDTO> _toIndexMap(Collection<ComponentDescriptionDTO> componentDescriptionDTOs) {
        HashMap<ComponentDescriptionKey, ComponentDescriptionDTO> componentDescriptionDTOIndexMap = new HashMap<ComponentDescriptionKey, ComponentDescriptionDTO>();
        for (ComponentDescriptionDTO componentDescriptionDTO : componentDescriptionDTOs) {
            componentDescriptionDTOIndexMap.put(new ComponentDescriptionKey(componentDescriptionDTO), componentDescriptionDTO);
        }
        return componentDescriptionDTOIndexMap;
    }

    private static class Dependency
    implements Comparable<Dependency> {
        private final ComponentDescriptionDTO _fromComponentDescriptionDTO;
        private final ReferenceDTO _referenceDTO;
        private final ComponentDescriptionDTO _toComponentDescriptionDTO;

        public void appendToChain(StringBundler sb) {
            sb.append(this._fromComponentDescriptionDTO.implementationClass);
            sb.append("[");
            if (this._referenceDTO.bind != null) {
                sb.append(this._referenceDTO.bind);
            }
            if (this._referenceDTO.field != null) {
                sb.append(this._referenceDTO.field);
            }
            sb.append("]");
            sb.append(" -> ");
        }

        @Override
        public int compareTo(Dependency dependency) {
            return _comparator.compare(this._toComponentDescriptionDTO, dependency._toComponentDescriptionDTO);
        }

        public boolean equals(Object object) {
            Dependency dependency = (Dependency)object;
            return this._toComponentDescriptionDTO == dependency._toComponentDescriptionDTO;
        }

        public ComponentDescriptionDTO getFromComponentDescriptionDTO() {
            return this._fromComponentDescriptionDTO;
        }

        public ReferenceDTO getReferenceDTO() {
            return this._referenceDTO;
        }

        public ComponentDescriptionDTO getToComponentDescriptionDTO() {
            return this._toComponentDescriptionDTO;
        }

        public int hashCode() {
            return this._toComponentDescriptionDTO.hashCode();
        }

        public String toString() {
            StringBundler sb = new StringBundler(7);
            if (this._fromComponentDescriptionDTO != null) {
                sb.append(this._fromComponentDescriptionDTO.implementationClass);
            }
            if (this._referenceDTO != null) {
                sb.append("[");
                if (this._referenceDTO.bind != null) {
                    sb.append(this._referenceDTO.bind);
                }
                if (this._referenceDTO.field != null) {
                    sb.append(this._referenceDTO.field);
                }
                sb.append("]");
                sb.append(" -> ");
            }
            sb.append(this._toComponentDescriptionDTO.implementationClass);
            return sb.toString();
        }

        private Dependency(ComponentDescriptionDTO fromComponentDescriptionDTO, ComponentDescriptionDTO toComponentDescriptionDTO, ReferenceDTO referenceDTO) {
            this._fromComponentDescriptionDTO = fromComponentDescriptionDTO;
            this._toComponentDescriptionDTO = toComponentDescriptionDTO;
            this._referenceDTO = referenceDTO;
        }
    }

    private static class ComponentDescriptionKey {
        private final long _bundleId;
        private final String _implementationClass;

        public boolean equals(Object object) {
            ComponentDescriptionKey componentDescriptionKey = (ComponentDescriptionKey)object;
            return this._bundleId == componentDescriptionKey._bundleId && Objects.equals(this._implementationClass, componentDescriptionKey._implementationClass);
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (long)this._bundleId);
            return HashUtil.hash((int)hash, (Object)this._implementationClass);
        }

        private ComponentDescriptionKey(ComponentDescriptionDTO componentDescriptionDTO) {
            BundleDTO bundleDTO = componentDescriptionDTO.bundle;
            this._bundleId = bundleDTO.id;
            this._implementationClass = componentDescriptionDTO.implementationClass;
        }

        private ComponentDescriptionKey(long bundleId, String implementationClass) {
            this._bundleId = bundleId;
            this._implementationClass = implementationClass;
        }
    }
}

