/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.validator;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.json.validator.JSONValidatorException;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONValidator {
    private static final org.everit.json.schema.Validator _validator = org.everit.json.schema.Validator.builder().build();
    private final DCLSingleton<Schema> _schemaDCLSingleton = new DCLSingleton();
    private final URL _url;

    public JSONValidator(URL url) {
        this._url = url;
    }

    public void validate(String json) throws JSONValidatorException {
        if (Validator.isNull((String)json)) {
            return;
        }
        try {
            _validator.performValidation((Schema)this._schemaDCLSingleton.getSingleton(this::_createSchema), (Object)new JSONObject(json));
        }
        catch (Exception exception) {
            if (exception instanceof JSONException) {
                JSONException jsonException = (JSONException)exception;
                throw new JSONValidatorException(jsonException.getMessage(), (Throwable)jsonException);
            }
            if (exception instanceof ValidationException) {
                ValidationException validationException = (ValidationException)exception;
                String errorMessage = validationException.getErrorMessage();
                List messages = validationException.getAllMessages();
                if (!messages.isEmpty()) {
                    ArrayList formattedMessages = new ArrayList();
                    messages.forEach(message -> {
                        if (message.startsWith("#: ")) {
                            message = message.substring(3);
                        } else if (message.startsWith("#")) {
                            message = message.substring(1);
                        }
                        formattedMessages.add(message);
                    });
                    errorMessage = StringUtil.merge(formattedMessages, (String)"\n");
                }
                throw new JSONValidatorException(errorMessage, exception);
            }
            throw new JSONValidatorException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema _createSchema() {
        try (InputStream inputStream = this._url.openStream();){
            Schema schema = SchemaLoader.load((JSONObject)new JSONObject(new JSONTokener(inputStream)));
            return schema;
        }
        catch (IOException ioException) {
            return (Schema)ReflectionUtil.throwException((Throwable)ioException);
        }
    }
}

