/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.executor.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.concurrent.NoticeableThreadPoolExecutor;
import com.liferay.petra.concurrent.ThreadPoolHandler;
import com.liferay.petra.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.petra.executor.PortalExecutorConfig;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={PortalExecutorManager.class})
public class DefaultPortalExecutorManager
implements PortalExecutorManager {
    public static final String DEFAULT_CONFIG_NAME = "default";
    private final PortalExecutorConfig _defaultPortalExecutorConfig = new PortalExecutorConfig("default", 1, 10, 60L, TimeUnit.SECONDS, Integer.MAX_VALUE, (ThreadFactory)new NamedThreadFactory("default", 5, PortalClassLoaderUtil.getClassLoader()), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy(), (ThreadPoolHandler)new ThreadPoolHandlerAdapter(){

        public void afterExecute(Runnable runnable, Throwable throwable) {
            CentralizedThreadLocal.clearShortLivedCentralizedThreadLocals();
        }
    });
    private final ConcurrentMap<String, NoticeableExecutorService> _noticeableExecutorServices = new ConcurrentHashMap<String, NoticeableExecutorService>();
    private ServiceTrackerMap<String, PortalExecutorConfig> _serviceTrackerMap;

    public NoticeableExecutorService getPortalExecutor(String name) {
        return this.getPortalExecutor(name, true);
    }

    public NoticeableExecutorService getPortalExecutor(String name, boolean createIfAbsent) {
        NoticeableExecutorService previousNoticeableExecutorService;
        NoticeableExecutorService noticeableExecutorService = (NoticeableExecutorService)this._noticeableExecutorServices.get(name);
        if (noticeableExecutorService == null && createIfAbsent && (previousNoticeableExecutorService = this.registerPortalExecutor(name, noticeableExecutorService = this._createPortalExecutor(name))) != null) {
            noticeableExecutorService.shutdown();
            noticeableExecutorService = previousNoticeableExecutorService;
        }
        return noticeableExecutorService;
    }

    public NoticeableExecutorService registerPortalExecutor(String name, NoticeableExecutorService noticeableExecutorService) {
        NoticeableExecutorService previousNoticeableExecutorService = this._noticeableExecutorServices.putIfAbsent(name, noticeableExecutorService);
        if (previousNoticeableExecutorService == null) {
            NoticeableFuture terminationNoticeableFuture = noticeableExecutorService.terminationNoticeableFuture();
            terminationNoticeableFuture.addFutureListener(future -> this._noticeableExecutorServices.remove(name));
        }
        return previousNoticeableExecutorService;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, PortalExecutorConfig.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (portalExecutorConfig, emitter) -> emitter.emit((Object)portalExecutorConfig.getName())));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
        for (NoticeableExecutorService noticeableExecutorService : this._noticeableExecutorServices.values()) {
            noticeableExecutorService.shutdownNow();
        }
    }

    private NoticeableExecutorService _createPortalExecutor(String executorName) {
        PortalExecutorConfig portalExecutorConfig = this._getPortalExecutorConfig(executorName);
        return new NoticeableThreadPoolExecutor(portalExecutorConfig.getCorePoolSize(), portalExecutorConfig.getMaxPoolSize(), portalExecutorConfig.getKeepAliveTime(), portalExecutorConfig.getTimeUnit(), new LinkedBlockingQueue(portalExecutorConfig.getMaxQueueSize()), portalExecutorConfig.getThreadFactory(), portalExecutorConfig.getRejectedExecutionHandler(), portalExecutorConfig.getThreadPoolHandler());
    }

    private PortalExecutorConfig _getPortalExecutorConfig(String name) {
        PortalExecutorConfig portalExecutorConfig = (PortalExecutorConfig)this._serviceTrackerMap.getService((Object)name);
        if (portalExecutorConfig != null) {
            return portalExecutorConfig;
        }
        PortalExecutorConfig defaultPortalExecutorConfig = (PortalExecutorConfig)this._serviceTrackerMap.getService((Object)DEFAULT_CONFIG_NAME);
        if (defaultPortalExecutorConfig != null) {
            return defaultPortalExecutorConfig;
        }
        return this._defaultPortalExecutorConfig;
    }
}

