/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.module.configuration.internal;

import aQute.bnd.annotation.metatype.Meta;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.configuration.module.configuration.internal.ConfigurationInvocationHandler;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.FallbackKeysSettingsUtil;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Dictionary;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConfigurationProvider.class})
public class ConfigurationProviderImpl
implements ConfigurationProvider {
    @Reference
    private ConfigurationAdmin _configurationAdmin;

    public <T> void deleteCompanyConfiguration(Class<T> clazz, long companyId) throws ConfigurationException {
        this._deleteFactoryConfiguration(this._getConfigurationPid(clazz), ExtendedObjectClassDefinition.Scope.COMPANY, Long.valueOf(companyId));
    }

    public <T> void deleteGroupConfiguration(Class<T> clazz, long groupId) throws ConfigurationException {
        this._deleteFactoryConfiguration(this._getConfigurationPid(clazz), ExtendedObjectClassDefinition.Scope.GROUP, Long.valueOf(groupId));
    }

    public <T> void deletePortletInstanceConfiguration(Class<T> clazz, String portletId) throws ConfigurationException {
        this._deleteFactoryConfiguration(this._getConfigurationPid(clazz), ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE, (Serializable)((Object)portletId));
    }

    public <T> void deleteSystemConfiguration(Class<T> clazz) throws ConfigurationException {
        this._deleteConfiguration(this._getConfigurationPid(clazz));
    }

    public <T> T getCompanyConfiguration(Class<T> clazz, long companyId) throws ConfigurationException {
        String settingsId = this._getSettingsId(clazz);
        String configurationPid = this._getConfigurationPid(clazz);
        return this.getConfiguration(clazz, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, settingsId, configurationPid));
    }

    public <T> T getConfiguration(Class<T> clazz, SettingsLocator settingsLocator) throws ConfigurationException {
        try {
            ConfigurationInvocationHandler<T> configurationInvocationHandler = new ConfigurationInvocationHandler<T>(clazz, new TypedSettings(FallbackKeysSettingsUtil.getSettings((SettingsLocator)settingsLocator)));
            return configurationInvocationHandler.createProxy();
        }
        catch (SettingsException | ReflectiveOperationException exception) {
            throw new ConfigurationException("Unable to load configuration of type " + clazz.getName(), exception);
        }
    }

    public <T> T getGroupConfiguration(Class<T> clazz, long groupId) throws ConfigurationException {
        String settingsId = this._getSettingsId(clazz);
        String configurationPid = this._getConfigurationPid(clazz);
        return this.getConfiguration(clazz, (SettingsLocator)new GroupServiceSettingsLocator(groupId, settingsId, configurationPid));
    }

    public <T> T getPortletInstanceConfiguration(Class<T> clazz, Layout layout, String portletId) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        if (Validator.isNull((String)configurationPid)) {
            return this.getConfiguration(clazz, (SettingsLocator)new PortletInstanceSettingsLocator(layout, portletId));
        }
        return this.getConfiguration(clazz, (SettingsLocator)new PortletInstanceSettingsLocator(layout, portletId, configurationPid));
    }

    public <T> T getPortletInstanceConfiguration(Class<T> clazz, ThemeDisplay themeDisplay) throws ConfigurationException {
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String portletResource = portletDisplay.getPortletResource();
        if (Validator.isNull((String)portletResource)) {
            return this.getPortletInstanceConfiguration(clazz, themeDisplay.getLayout(), portletDisplay.getId());
        }
        return this.getPortletInstanceConfiguration(clazz, themeDisplay.getLayout(), portletResource);
    }

    public <T> T getSystemConfiguration(Class<T> clazz) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        return this.getConfiguration(clazz, (SettingsLocator)new SystemSettingsLocator(configurationPid));
    }

    public <T> void saveCompanyConfiguration(Class<T> clazz, long companyId, Dictionary<String, Object> properties) throws ConfigurationException {
        this._saveFactoryConfiguration(this._getConfigurationPid(clazz), ExtendedObjectClassDefinition.Scope.COMPANY, Long.valueOf(companyId), properties);
    }

    public <T> void saveCompanyConfiguration(long companyId, String pid, Dictionary<String, Object> properties) throws ConfigurationException {
        this._saveFactoryConfiguration(pid, ExtendedObjectClassDefinition.Scope.COMPANY, Long.valueOf(companyId), properties);
    }

    public <T> void saveGroupConfiguration(Class<T> clazz, long groupId, Dictionary<String, Object> properties) throws ConfigurationException {
        this._saveFactoryConfiguration(this._getConfigurationPid(clazz), ExtendedObjectClassDefinition.Scope.GROUP, Long.valueOf(groupId), properties);
    }

    public <T> void saveGroupConfiguration(long groupId, String pid, Dictionary<String, Object> properties) throws ConfigurationException {
        this._saveFactoryConfiguration(pid, ExtendedObjectClassDefinition.Scope.GROUP, Long.valueOf(groupId), properties);
    }

    public <T> void savePortletInstanceConfiguration(Class<T> clazz, String portletId, Dictionary<String, Object> properties) throws ConfigurationException {
        this._saveFactoryConfiguration(this._getConfigurationPid(clazz), ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE, (Serializable)((Object)portletId), properties);
    }

    public <T> void saveSystemConfiguration(Class<T> clazz, Dictionary<String, Object> properties) throws ConfigurationException {
        this._saveConfiguration(this._getConfigurationPid(clazz), properties);
    }

    private void _deleteConfiguration(String pid) throws ConfigurationException {
        try {
            String pidFilter = StringBundler.concat((String[])new String[]{"(", "service.pid", "=", pid, ")"});
            Configuration[] configurations = this._configurationAdmin.listConfigurations(pidFilter);
            if (configurations != null) {
                configurations[0].delete();
            }
        }
        catch (IOException | InvalidSyntaxException exception) {
            throw new ConfigurationException("Unable to delete configuration " + pid, exception);
        }
    }

    private void _deleteFactoryConfiguration(String factoryPid, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) throws ConfigurationException {
        String scopedFactoryPid = factoryPid + ".scoped";
        try {
            Configuration configuration = this._getFactoryConfiguration(scopedFactoryPid, scope, scopePK);
            if (configuration != null) {
                configuration.delete();
            }
        }
        catch (IOException ioException) {
            throw new ConfigurationException("Unable to delete factory configuration " + scopedFactoryPid, (Throwable)ioException);
        }
    }

    private String _getConfigurationPid(Class<?> clazz) {
        Meta.OCD ocd = clazz.getAnnotation(Meta.OCD.class);
        if (ocd == null) {
            return null;
        }
        return ocd.id();
    }

    private Configuration _getFactoryConfiguration(String factoryPid, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) throws ConfigurationException {
        try {
            String filterString = StringBundler.concat((Object[])new Object[]{"(&(service.factoryPid=", factoryPid, ")(", scope.getPropertyKey(), "=", scopePK, "))"});
            Configuration[] configurations = this._configurationAdmin.listConfigurations(filterString);
            if (configurations != null) {
                return configurations[0];
            }
            return null;
        }
        catch (IOException | InvalidSyntaxException exception) {
            throw new ConfigurationException("Unable to retrieve factory configuration " + factoryPid, exception);
        }
    }

    private <T> String _getSettingsId(Class<T> clazz) {
        String settingsId = null;
        ExtendedObjectClassDefinition eocd = clazz.getAnnotation(ExtendedObjectClassDefinition.class);
        if (eocd != null) {
            settingsId = eocd.settingsId();
        }
        if (Validator.isNull(settingsId)) {
            settingsId = this._getConfigurationPid(clazz);
        }
        return settingsId;
    }

    private void _saveConfiguration(String pid, Dictionary<String, Object> properties) throws ConfigurationException {
        try {
            Configuration configuration = this._configurationAdmin.getConfiguration(pid, "?");
            configuration.update(properties);
        }
        catch (IOException ioException) {
            throw new ConfigurationException("Unable to save configuration " + pid, (Throwable)ioException);
        }
    }

    private void _saveFactoryConfiguration(String factoryPid, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK, Dictionary<String, Object> properties) throws ConfigurationException {
        String scopedFactoryPid = factoryPid + ".scoped";
        try {
            Configuration configuration = this._getFactoryConfiguration(scopedFactoryPid, scope, scopePK);
            if (configuration == null) {
                configuration = this._configurationAdmin.createFactoryConfiguration(scopedFactoryPid, "?");
            }
            properties.put(scope.getPropertyKey(), scopePK);
            configuration.update(properties);
        }
        catch (IOException ioException) {
            throw new ConfigurationException("Unable to save factory configuration " + scopedFactoryPid, (Throwable)ioException);
        }
    }
}

