/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.module.configuration.internal;

import aQute.bnd.annotation.metatype.Meta;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.metatype.util.ConfigurationScopedPidUtil;
import com.liferay.portal.configuration.module.configuration.internal.ConfigurationInvocationHandler;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletInstance;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Dictionary;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ConfigurationProvider.class})
public class ConfigurationProviderImpl
implements ConfigurationProvider {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private SettingsFactory _settingsFactory;

    public <T> void deleteCompanyConfiguration(Class<T> clazz, long companyId) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        String scopedPid = ConfigurationScopedPidUtil.buildConfigurationScopedPid((String)configurationPid, (ExtendedObjectClassDefinition.Scope)ExtendedObjectClassDefinition.Scope.COMPANY, (String)String.valueOf(companyId));
        this._deleteConfiguration(scopedPid);
    }

    public <T> void deleteGroupConfiguration(Class<T> clazz, long groupId) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        String scopedPid = ConfigurationScopedPidUtil.buildConfigurationScopedPid((String)configurationPid, (ExtendedObjectClassDefinition.Scope)ExtendedObjectClassDefinition.Scope.GROUP, (String)String.valueOf(groupId));
        this._deleteConfiguration(scopedPid);
    }

    public <T> void deletePortletInstanceConfiguration(Class<T> clazz, String portletId) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        String scopedPid = ConfigurationScopedPidUtil.buildConfigurationScopedPid((String)configurationPid, (ExtendedObjectClassDefinition.Scope)ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE, (String)portletId);
        this._deleteConfiguration(scopedPid);
    }

    public <T> void deleteSystemConfiguration(Class<T> clazz) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        this._deleteConfiguration(configurationPid);
    }

    public <T> T getCompanyConfiguration(Class<T> clazz, long companyId) throws ConfigurationException {
        String settingsId = this._getSettingsId(clazz);
        String configurationPid = this._getConfigurationPid(clazz);
        return this.getConfiguration(clazz, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, settingsId, configurationPid));
    }

    public <T> T getConfiguration(Class<T> clazz, SettingsLocator settingsLocator) throws ConfigurationException {
        try {
            ConfigurationInvocationHandler<T> configurationInvocationHandler = new ConfigurationInvocationHandler<T>(clazz, new TypedSettings(this._settingsFactory.getSettings(settingsLocator)));
            return configurationInvocationHandler.createProxy();
        }
        catch (SettingsException | ReflectiveOperationException e) {
            throw new ConfigurationException("Unable to load configuration of type " + clazz.getName(), e);
        }
    }

    public <T> T getGroupConfiguration(Class<T> clazz, long groupId) throws ConfigurationException {
        String settingsId = this._getSettingsId(clazz);
        String configurationPid = this._getConfigurationPid(clazz);
        return this.getConfiguration(clazz, (SettingsLocator)new GroupServiceSettingsLocator(groupId, settingsId, configurationPid));
    }

    @Deprecated
    public <T> T getPortletInstanceConfiguration(Class<T> clazz, Layout layout, PortletInstance portletInstance) throws ConfigurationException {
        return this.getPortletInstanceConfiguration(clazz, layout, portletInstance.getPortletInstanceKey());
    }

    public <T> T getPortletInstanceConfiguration(Class<T> clazz, Layout layout, String portletId) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        if (Validator.isNull((String)configurationPid)) {
            return this.getConfiguration(clazz, (SettingsLocator)new PortletInstanceSettingsLocator(layout, portletId));
        }
        return this.getConfiguration(clazz, (SettingsLocator)new PortletInstanceSettingsLocator(layout, portletId, configurationPid));
    }

    public <T> T getSystemConfiguration(Class<T> clazz) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        return this.getConfiguration(clazz, (SettingsLocator)new SystemSettingsLocator(configurationPid));
    }

    public <T> void saveCompanyConfiguration(Class<T> clazz, long companyId, Dictionary<String, Object> properties) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        String scopedPid = ConfigurationScopedPidUtil.buildConfigurationScopedPid((String)configurationPid, (ExtendedObjectClassDefinition.Scope)ExtendedObjectClassDefinition.Scope.COMPANY, (String)String.valueOf(companyId));
        this._saveConfiguration(scopedPid, properties);
    }

    public <T> void saveGroupConfiguration(Class<T> clazz, long groupId, Dictionary<String, Object> properties) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        String scopedPid = ConfigurationScopedPidUtil.buildConfigurationScopedPid((String)configurationPid, (ExtendedObjectClassDefinition.Scope)ExtendedObjectClassDefinition.Scope.GROUP, (String)String.valueOf(groupId));
        this._saveConfiguration(scopedPid, properties);
    }

    public <T> void savePortletInstanceConfiguration(Class<T> clazz, String portletId, Dictionary<String, Object> properties) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        String scopedPid = ConfigurationScopedPidUtil.buildConfigurationScopedPid((String)configurationPid, (ExtendedObjectClassDefinition.Scope)ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE, (String)portletId);
        this._saveConfiguration(scopedPid, properties);
    }

    public <T> void saveSystemConfiguration(Class<T> clazz, Dictionary<String, Object> properties) throws ConfigurationException {
        String configurationPid = this._getConfigurationPid(clazz);
        this._saveConfiguration(configurationPid, properties);
    }

    private void _deleteConfiguration(String pid) throws ConfigurationException {
        try {
            String pidFilter = StringBundler.concat((String[])new String[]{"(", "service.pid", "=", pid, ")"});
            Configuration[] configurations = this._configurationAdmin.listConfigurations(pidFilter);
            if (configurations != null) {
                configurations[0].delete();
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            throw new ConfigurationException("Unable to delete configuration " + pid, e);
        }
    }

    private String _getConfigurationPid(Class<?> clazz) {
        Meta.OCD ocd = clazz.getAnnotation(Meta.OCD.class);
        if (ocd == null) {
            return null;
        }
        return ocd.id();
    }

    private <T> String _getSettingsId(Class<T> clazz) {
        ExtendedObjectClassDefinition eocd = clazz.getAnnotation(ExtendedObjectClassDefinition.class);
        String settingsId = null;
        if (eocd != null) {
            settingsId = eocd.settingsId();
        }
        if (Validator.isNull(settingsId)) {
            settingsId = this._getConfigurationPid(clazz);
        }
        return settingsId;
    }

    private void _saveConfiguration(String pid, Dictionary<String, Object> properties) throws ConfigurationException {
        try {
            Configuration configuration = this._configurationAdmin.getConfiguration(pid, "?");
            configuration.update(properties);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Unable to save configuration " + pid, (Throwable)ioe);
        }
    }
}

