/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.classloader.tracker.internal.activator;

import com.liferay.petra.lang.ClassLoaderPool;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;

public class ClassLoaderTrackerBundleActivator
implements BundleActivator {
    private BundleTracker<ClassLoader> _bundleTracker;

    public void start(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker<ClassLoader>(bundleContext, 40, null){

            public ClassLoader addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                ClassLoader classLoader = bundleWiring.getClassLoader();
                ClassLoaderPool.register((String)ClassLoaderTrackerBundleActivator.this._toClassLoaderName(bundle), (ClassLoader)classLoader);
                return classLoader;
            }

            public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ClassLoader classLoader) {
                ClassLoaderPool.unregister((ClassLoader)classLoader);
            }
        };
        this._bundleTracker.open();
    }

    public void stop(BundleContext bundleContext) {
        this._bundleTracker.close();
    }

    private String _toClassLoaderName(Bundle bundle) {
        String classLoaderName = bundle.getSymbolicName();
        classLoaderName = classLoaderName.concat("_");
        return classLoaderName.concat(String.valueOf(bundle.getVersion()));
    }
}

