/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal.cluster.link;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CoalescedPipe<E> {
    private static final Log _log = LogFactoryUtil.getLog(CoalescedPipe.class);
    private final AtomicLong _coalescedCount = new AtomicLong(0L);
    private final Comparator<E> _comparator;
    private ElementLink<E> _headElementLink;
    private ElementLink<E> _lastElementLink;
    private final Condition _notEmptyCondition;
    private final AtomicInteger _pendingCount = new AtomicInteger(0);
    private final ReentrantLock _putLock = new ReentrantLock();
    private final ReentrantLock _takeLock = new ReentrantLock();

    public CoalescedPipe() {
        this(null);
    }

    public CoalescedPipe(Comparator<E> comparator) {
        this._comparator = comparator;
        this._notEmptyCondition = this._takeLock.newCondition();
        this._headElementLink = new ElementLink<Object>(null);
        this._lastElementLink = this._headElementLink;
    }

    public long coalescedCount() {
        return this._coalescedCount.get();
    }

    public int pendingCount() {
        return this._pendingCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        int pendingElements = -1;
        this._putLock.lockInterruptibly();
        try {
            if (this._coalesceElement(e)) {
                return;
            }
            this._lastElementLink._nextElementLink = new ElementLink<E>(e);
            this._lastElementLink = this._lastElementLink._nextElementLink;
            pendingElements = this._pendingCount.getAndIncrement();
        }
        finally {
            this._putLock.unlock();
        }
        if (pendingElements == 0) {
            this._takeLock.lock();
            try {
                this._notEmptyCondition.signal();
            }
            finally {
                this._takeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take() throws InterruptedException {
        E element = null;
        this._takeLock.lockInterruptibly();
        try {
            while (this._pendingCount.get() == 0) {
                this._notEmptyCondition.await();
            }
            ElementLink<E> garbageElementLink = this._headElementLink;
            this._headElementLink = this._headElementLink._nextElementLink;
            garbageElementLink._nextElementLink = null;
            element = this._headElementLink._element;
            this._headElementLink._element = null;
            int pendingElements = this._pendingCount.getAndDecrement();
            if (pendingElements > 1) {
                this._notEmptyCondition.signal();
            }
        }
        finally {
            this._takeLock.unlock();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] takeSnapshot() {
        this._putLock.lock();
        this._takeLock.lock();
        try {
            Object[] pendingElements = new Object[this._pendingCount.get()];
            ElementLink currentElementLink = this._headElementLink._nextElementLink;
            int i = 0;
            while (currentElementLink != null) {
                pendingElements[i] = currentElementLink._element;
                currentElementLink = currentElementLink._nextElementLink;
                ++i;
            }
            Object[] objectArray = pendingElements;
            return objectArray;
        }
        finally {
            this._putLock.unlock();
            this._takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _coalesceElement(E e) {
        try {
            this._takeLock.lockInterruptibly();
            try {
                ElementLink currentElementLink = this._headElementLink._nextElementLink;
                if (this._comparator != null) {
                    while (currentElementLink != null) {
                        int compare = this._comparator.compare(currentElementLink._element, e);
                        if (compare == 0) {
                            this._coalescedCount.incrementAndGet();
                            boolean bl = true;
                            return bl;
                        }
                        currentElementLink = currentElementLink._nextElementLink;
                    }
                    return false;
                }
                while (currentElementLink != null) {
                    if (currentElementLink._element.equals(e)) {
                        this._coalescedCount.incrementAndGet();
                        boolean bl = true;
                        return bl;
                    }
                    currentElementLink = currentElementLink._nextElementLink;
                }
                return false;
            }
            finally {
                this._takeLock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            if (!_log.isDebugEnabled()) return false;
            _log.debug((Throwable)interruptedException);
        }
        return false;
    }

    private static class ElementLink<E> {
        private E _element;
        private ElementLink<E> _nextElementLink;

        private ElementLink(E element) {
            this._element = element;
        }
    }
}

