/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.extender.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;

public class PortalCacheExtenderUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortalCacheExtenderUtil.class);

    public static BundleTracker<Void> createBundleTracker(BundleContext bundleContext, final PortalCacheManager<?, ?> portalCacheManager, final String propertyKey, final String defaultConfigurationFile) {
        return new BundleTracker<Void>(bundleContext, 32, null){

            public Void addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                URL configurationURL;
                BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                ClassLoader classLoader = bundleWiring.getClassLoader();
                String configurationFile = null;
                if (classLoader.getResource("portlet.properties") != null) {
                    Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
                    configurationFile = configuration.get(propertyKey);
                }
                if (Validator.isNull(configurationFile)) {
                    configurationFile = defaultConfigurationFile;
                }
                if ((configurationURL = classLoader.getResource(configurationFile)) != null) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((Object[])new Object[]{"Reconfiguring caches in cache manager ", portalCacheManager.getPortalCacheManagerName(), " using ", configurationURL}));
                    }
                    portalCacheManager.reconfigurePortalCaches(configurationURL, classLoader);
                }
                return null;
            }
        };
    }
}

