/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.process;

import com.liferay.petra.concurrent.BaseFutureListener;
import com.liferay.petra.concurrent.DefaultNoticeableFuture;
import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.OutputProcessor;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.TerminationProcessException;
import com.liferay.petra.string.StringBundler;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicMarkableReference;

public class ProcessUtil {
    public static <O, E> NoticeableFuture<Map.Entry<O, E>> execute(OutputProcessor<O, E> outputProcessor, List<String> arguments) throws ProcessException {
        if (outputProcessor == null) {
            throw new NullPointerException("Output processor is null");
        }
        if (arguments == null) {
            throw new NullPointerException("Arguments is null");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        String threadNamePrefix = ProcessUtil._buildThreadNamePrefix(arguments);
        try {
            Process process = processBuilder.start();
            NoticeableFuture<O> stdOutNoticeableFuture = ProcessUtil._submit(threadNamePrefix.concat("StdOut"), new ProcessStdOutCallable<O>(outputProcessor, process));
            NoticeableFuture<E> stdErrNoticeableFuture = ProcessUtil._submit(threadNamePrefix.concat("StdErr"), new ProcessStdErrCallable<E>(outputProcessor, process));
            return ProcessUtil._wrapNoticeableFuture(stdOutNoticeableFuture, stdErrNoticeableFuture, process);
        }
        catch (IOException ioException) {
            throw new ProcessException(ioException);
        }
    }

    public static <O, E> NoticeableFuture<Map.Entry<O, E>> execute(OutputProcessor<O, E> outputProcessor, String ... arguments) throws ProcessException {
        return ProcessUtil.execute(outputProcessor, Arrays.asList(arguments));
    }

    private static String _buildThreadNamePrefix(List<String> arguments) {
        StringBundler sb = new StringBundler(arguments.size() * 2 + 1);
        sb.append("[");
        for (String argument : arguments) {
            sb.append(argument);
            sb.append(" ");
        }
        sb.setStringAt("]", sb.index() - 1);
        sb.append("-");
        return sb.toString();
    }

    private static <T> NoticeableFuture<T> _submit(String threadName, Callable<T> callable) {
        DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture(callable);
        Thread thread = new Thread((Runnable)defaultNoticeableFuture, threadName);
        thread.setDaemon(true);
        thread.start();
        return defaultNoticeableFuture;
    }

    private static <O, E> NoticeableFuture<Map.Entry<O, E>> _wrapNoticeableFuture(NoticeableFuture<O> stdOutNoticeableFuture, NoticeableFuture<E> stdErrNoticeableFuture, Process process) {
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        defaultNoticeableFuture.addFutureListener(future -> {
            if (!future.isCancelled()) {
                return;
            }
            stdOutNoticeableFuture.cancel(true);
            stdErrNoticeableFuture.cancel(true);
            process.destroy();
        });
        final AtomicMarkableReference<Object> stdOutReference = new AtomicMarkableReference<Object>(null, false);
        final AtomicMarkableReference<Object> stdErrReference = new AtomicMarkableReference<Object>(null, false);
        stdOutNoticeableFuture.addFutureListener((FutureListener)new BaseFutureListener<O>(){

            public void completeWithCancel(Future<O> future) {
                defaultNoticeableFuture.cancel(true);
            }

            public void completeWithException(Future<O> future, Throwable throwable) {
                defaultNoticeableFuture.setException(throwable);
            }

            public void completeWithResult(Future<O> future, O stdOut) {
                stdOutReference.set(stdOut, true);
                boolean[] markHolder = new boolean[1];
                Object stdErr = stdErrReference.get(markHolder);
                if (markHolder[0]) {
                    defaultNoticeableFuture.set(new AbstractMap.SimpleEntry(stdOut, stdErr));
                }
            }
        });
        stdErrNoticeableFuture.addFutureListener((FutureListener)new BaseFutureListener<E>(){

            public void completeWithCancel(Future<E> future) {
                defaultNoticeableFuture.cancel(true);
            }

            public void completeWithException(Future<E> future, Throwable throwable) {
                defaultNoticeableFuture.setException(throwable);
            }

            public void completeWithResult(Future<E> future, E stdErr) {
                stdErrReference.set(stdErr, true);
                boolean[] markHolder = new boolean[1];
                Object stdOut = stdOutReference.get(markHolder);
                if (markHolder[0]) {
                    defaultNoticeableFuture.set(new AbstractMap.SimpleEntry(stdOut, stdErr));
                }
            }
        });
        return defaultNoticeableFuture;
    }

    private static class ProcessStdOutCallable<T>
    implements Callable<T> {
        private final OutputProcessor<T, ?> _outputProcessor;
        private final Process _process;

        @Override
        public T call() throws Exception {
            try {
                T t = this._outputProcessor.processStdOut(this._process.getInputStream());
                return t;
            }
            finally {
                try {
                    int exitCode = this._process.waitFor();
                    if (exitCode != 0) {
                        throw new TerminationProcessException(exitCode);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this._process.destroy();
                    throw new ProcessException("Forcibly killed subprocess on interruption", interruptedException);
                }
            }
        }

        private ProcessStdOutCallable(OutputProcessor<T, ?> outputProcessor, Process process) {
            this._outputProcessor = outputProcessor;
            this._process = process;
        }
    }

    private static class ProcessStdErrCallable<T>
    implements Callable<T> {
        private final OutputProcessor<?, T> _outputProcessor;
        private final Process _process;

        @Override
        public T call() throws Exception {
            return this._outputProcessor.processStdErr(this._process.getErrorStream());
        }

        private ProcessStdErrCallable(OutputProcessor<?, T> outputProcessor, Process process) {
            this._outputProcessor = outputProcessor;
            this._process = process;
        }
    }
}

