/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.process;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.petra.process.OutputProcessor;
import com.liferay.petra.process.ProcessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CollectorOutputProcessor
implements OutputProcessor<byte[], byte[]> {
    public static final OutputProcessor<byte[], byte[]> INSTANCE = new CollectorOutputProcessor();

    @Override
    public byte[] processStdErr(InputStream stdErrInputStream) throws ProcessException {
        return this._collect(stdErrInputStream);
    }

    @Override
    public byte[] processStdOut(InputStream stdOutInputStream) throws ProcessException {
        return this._collect(stdOutInputStream);
    }

    private byte[] _collect(InputStream inputStream) throws ProcessException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try {
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream);
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }
}

