/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.concurrent;

import com.liferay.petra.concurrent.ConcurrentMapperHashMap;
import com.liferay.petra.memory.FinalizeAction;
import com.liferay.petra.memory.FinalizeManager;
import java.lang.ref.Reference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentReferenceValueHashMap<K, V>
extends ConcurrentMapperHashMap<K, K, V, Reference<V>> {
    private final FinalizeManager.ReferenceFactory _referenceFactory;

    public ConcurrentReferenceValueHashMap(ConcurrentMap<K, Reference<V>> innerConcurrentMap, FinalizeManager.ReferenceFactory referenceFactory) {
        super(innerConcurrentMap);
        this._referenceFactory = referenceFactory;
    }

    public ConcurrentReferenceValueHashMap(FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(), referenceFactory);
    }

    public ConcurrentReferenceValueHashMap(int initialCapacity, FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(initialCapacity), referenceFactory);
    }

    public ConcurrentReferenceValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel), referenceFactory);
    }

    @Override
    protected K mapKey(K key) {
        return key;
    }

    @Override
    protected K mapKeyForQuery(K key) {
        return key;
    }

    @Override
    protected Reference<V> mapValue(K key, V value) {
        RemoveEntryFinalizeAction removeEntryFinalizeAction = new RemoveEntryFinalizeAction(key);
        Reference innerValue = FinalizeManager.register(value, (FinalizeAction)removeEntryFinalizeAction, (FinalizeManager.ReferenceFactory)this._referenceFactory);
        removeEntryFinalizeAction._innerValue = innerValue;
        return innerValue;
    }

    @Override
    protected Reference<V> mapValueForQuery(V value) {
        return this._referenceFactory.createReference(value, null);
    }

    @Override
    protected K unmapKey(K key) {
        return key;
    }

    @Override
    protected K unmapKeyForQuery(K key) {
        return key;
    }

    @Override
    protected V unmapValue(Reference<V> reference) {
        V value = reference.get();
        reference.clear();
        return value;
    }

    @Override
    protected V unmapValueForQuery(Reference<V> reference) {
        return reference.get();
    }

    private class RemoveEntryFinalizeAction
    implements FinalizeAction {
        private Reference<V> _innerValue;
        private final K _key;

        public void doFinalize(Reference<?> reference) {
            ConcurrentReferenceValueHashMap.this.innerConcurrentMap.remove(this._key, this._innerValue);
        }

        private RemoveEntryFinalizeAction(K key) {
            this._key = key;
        }
    }
}

