/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osb.spring.boot.client.zendesk.service;

import com.liferay.osb.spring.boot.client.zendesk.model.ZendeskOrganization;
import com.liferay.osb.spring.boot.client.zendesk.model.ZendeskTicket;
import com.liferay.osb.spring.boot.client.zendesk.model.ZendeskUser;
import com.liferay.osb.spring.boot.client.zendesk.search.SearchHits;
import com.liferay.osb.spring.boot.client.zendesk.search.ZendeskTicketQuery;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class ZendeskService {
    @Value(value="${liferay.osb.spring.boot.client.zendesk.api.email.address}")
    private String _zendeskAPIEmailAddress;
    @Value(value="${liferay.osb.spring.boot.client.zendesk.api.token}")
    private String _zendeskAPIToken;
    private String _zendeskAuthorization;
    @Value(value="${liferay.osb.spring.boot.client.zendesk.url}")
    private String _zendeskURL;

    public void addAgentZendeskTicketComment(String htmlBody, long zendeskTicketId, long zendeskUserId) throws Exception {
        JSONObject commentJSONObject = new JSONObject();
        commentJSONObject.put("author_id", zendeskUserId).put("html_body", (Object)htmlBody).put("public", true);
        JSONObject ticketJSONObject = new JSONObject();
        ticketJSONObject.put("comment", (Object)commentJSONObject);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ticket", (Object)ticketJSONObject);
        ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WebClient.create((String)this._zendeskURL).put().uri("/api/v2/tickets/" + zendeskTicketId + ".json", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{this._zendeskAuthorization})).body(BodyInserters.fromValue((Object)jsonObject.toString())).retrieve().bodyToMono(String.class).block();
    }

    public void addEndUserZendeskTicketComment(String emailAddress, String htmlBody, long zendeskTicketId) throws Exception {
        JSONObject commentJSONObject = new JSONObject();
        commentJSONObject.put("html_body", (Object)htmlBody);
        JSONObject ticketJSONObject = new JSONObject();
        ticketJSONObject.put("comment", (Object)commentJSONObject);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("request", (Object)ticketJSONObject);
        ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WebClient.create((String)this._zendeskURL).put().uri("/api/v2/requests/" + zendeskTicketId + ".json", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{this._getAuthorization(emailAddress)})).body(BodyInserters.fromValue((Object)jsonObject.toString())).retrieve().bodyToMono(String.class).block();
    }

    public ZendeskUser fetchZendeskUser(String emailAddress) throws Exception {
        JSONObject jsonObject = new JSONObject((String)WebClient.create((String)this._zendeskURL).get().uri("/api/v2/users/search.json?query=" + emailAddress, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).header("Authorization", new String[]{this._zendeskAuthorization}).retrieve().bodyToMono(String.class).block());
        JSONArray jsonArray = jsonObject.getJSONArray("users");
        if (jsonArray.length() <= 0) {
            return null;
        }
        return new ZendeskUser(jsonArray.getJSONObject(0));
    }

    public ZendeskOrganization getZendeskOrganization(long zendeskOrganizationId) throws Exception {
        JSONObject jsonObject = new JSONObject((String)WebClient.create((String)this._zendeskURL).get().uri("/api/v2/organizations/" + zendeskOrganizationId + ".json", new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).header("Authorization", new String[]{this._zendeskAuthorization}).retrieve().bodyToMono(String.class).block());
        return new ZendeskOrganization(jsonObject.getJSONObject("organization"));
    }

    public ZendeskTicket getZendeskTicket(long zendeskTicketId) throws Exception {
        JSONObject jsonObject = new JSONObject((String)WebClient.create((String)this._zendeskURL).get().uri("/api/v2/tickets/" + zendeskTicketId + ".json", new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).header("Authorization", new String[]{this._zendeskAuthorization}).retrieve().bodyToMono(String.class).block());
        return new ZendeskTicket(jsonObject.getJSONObject("ticket"));
    }

    @PostConstruct
    public void init() throws Exception {
        this._zendeskAuthorization = this._getAuthorization(this._zendeskAPIEmailAddress);
    }

    public SearchHits<ZendeskTicket> search(ZendeskTicketQuery zendeskTicketQuery) throws Exception {
        JSONObject jsonObject = new JSONObject((String)WebClient.create((String)(this._zendeskURL + "/api/v2/search.json")).get().uri(uriBuilder -> {
            Map<String, String> parameters = zendeskTicketQuery.getParameters();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                uriBuilder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
            return uriBuilder.build(new Object[0]);
        }).accept(new MediaType[]{MediaType.APPLICATION_JSON}).header("Authorization", new String[]{this._zendeskAuthorization}).retrieve().bodyToMono(String.class).block());
        return this.toSearchHits(jsonObject);
    }

    protected SearchHits<ZendeskTicket> toSearchHits(JSONObject jsonObject) {
        SearchHits<ZendeskTicket> searchHits = new SearchHits<ZendeskTicket>();
        searchHits.setCount(jsonObject.getInt("count"));
        String nextPageURL = jsonObject.optString("next_page");
        if (!nextPageURL.equals("")) {
            String page = this._getParameter(nextPageURL, "page");
            searchHits.setNextPage(Integer.valueOf(page));
        }
        ArrayList<ZendeskTicket> zendeskTickets = new ArrayList<ZendeskTicket>();
        JSONArray jsonArray = jsonObject.getJSONArray("results");
        for (int i = 0; i < jsonArray.length(); ++i) {
            zendeskTickets.add(new ZendeskTicket(jsonArray.getJSONObject(i)));
        }
        searchHits.setResults(zendeskTickets);
        return searchHits;
    }

    private String _getAuthorization(String emailAddress) throws Exception {
        Base64.Encoder encoder = Base64.getEncoder();
        String zendeskCredentials = emailAddress + "/token:" + this._zendeskAPIToken;
        String encodedZendeskCredentials = new String(encoder.encode(zendeskCredentials.getBytes("UTF-8")), "UTF-8");
        return "Basic " + encodedZendeskCredentials;
    }

    private String _getParameter(String url, String name) {
        int x = url.indexOf("?");
        int y = url.indexOf(name + "=", x);
        if (y < 0) {
            return "";
        }
        int z = url.indexOf("&", y);
        if (z < 0) {
            return url.substring(y + name.length() + 1);
        }
        return url.substring(y + name.length() + 1, z);
    }
}

