/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osb.spring.boot.client.zendesk.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Query {
    private final Set<String> _criteria = new HashSet<String>();
    private int _page;
    private final Map<String, String> _parameters = new HashMap<String, String>();
    private final Set<String> _sideloads = new HashSet<String>();
    private String _sortBy;
    private String _sortOrder;

    public void addCriterion(String criterion) {
        this._criteria.add(criterion);
    }

    public void addParameter(String key, String value) {
        this._parameters.put(key, value);
    }

    public void addSideload(String sideload) {
        this._sideloads.add(sideload);
    }

    public int getPage() {
        return this._page;
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (!this._parameters.isEmpty()) {
            parameters.putAll(this._parameters);
        }
        if (!this._sideloads.isEmpty()) {
            parameters.put("include", this.getSideLoads());
        }
        if (this._page > 0) {
            parameters.put("page", String.valueOf(this._page));
        }
        if (!this._criteria.isEmpty()) {
            parameters.put("query", this.getQuery());
        }
        if (this._sortBy != null) {
            parameters.put("sort_by", this._sortBy);
            if (this._sortOrder != null) {
                parameters.put("sort_order", this._sortOrder);
            }
        }
        return parameters;
    }

    public void setPage(int page) {
        this._page = page;
    }

    public void setSortBy(String sortBy) {
        this._sortBy = sortBy;
    }

    public void setSortOrder(boolean asc) {
        this._sortOrder = asc ? "asc" : "desc";
    }

    protected String getQuery() {
        StringBuilder sb = new StringBuilder();
        for (String criterion : this._criteria) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(criterion);
        }
        return sb.toString();
    }

    protected String getSideLoads() {
        StringBuilder sb = new StringBuilder();
        for (String sideload : this._sideloads) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(sideload);
        }
        return sb.toString();
    }
}

