/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.storage.sugarcrm.internal.odata.filter.expression;

import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.ListExpression;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MemberExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.PrimitivePropertyExpression;
import java.util.List;
import java.util.Objects;

public class SugarCRMQueryExpressionVisitorImpl
implements ExpressionVisitor<Object> {
    private static final Log _log = LogFactoryUtil.getLog(SugarCRMQueryExpressionVisitorImpl.class);
    private final long _objectDefinitionId;
    private final ObjectFieldLocalService _objectFieldLocalService;

    public SugarCRMQueryExpressionVisitorImpl(long objectDefinitionId, ObjectFieldLocalService objectFieldLocalService) {
        this._objectDefinitionId = objectDefinitionId;
        this._objectFieldLocalService = objectFieldLocalService;
    }

    public String visitBinaryExpressionOperation(BinaryExpression.Operation operation, Object left, Object right) throws ExpressionVisitException {
        StringBuilder sb = new StringBuilder();
        if (Objects.equals(BinaryExpression.Operation.AND, operation)) {
            this._buildBinaryOperationAndOr(left, "$and", right, sb);
        } else if (Objects.equals(BinaryExpression.Operation.OR, operation)) {
            this._buildBinaryOperationAndOr(left, "$or", right, sb);
        } else {
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(this._objectDefinitionId, (String)left);
            if (objectField != null) {
                left = objectField.getExternalReferenceCode();
                right = StringUtil.unquote((String)((String)right));
            }
        }
        if (Objects.equals(BinaryExpression.Operation.EQ, operation)) {
            this._buildBinaryOperation(left, "$equals", right, sb);
        } else if (Objects.equals(BinaryExpression.Operation.GE, operation)) {
            this._buildBinaryOperation(left, "$gte", right, sb);
        } else if (Objects.equals(BinaryExpression.Operation.GT, operation)) {
            this._buildBinaryOperation(left, "$gt", right, sb);
        } else if (Objects.equals(BinaryExpression.Operation.LE, operation)) {
            this._buildBinaryOperation(left, "$lte", right, sb);
        } else if (Objects.equals(BinaryExpression.Operation.LT, operation)) {
            this._buildBinaryOperation(left, "$lt", right, sb);
        } else if (Objects.equals(BinaryExpression.Operation.NE, operation)) {
            this._buildBinaryOperation(left, "$not_equals", right, sb);
        }
        if (Validator.isNull((String)sb.toString())) {
            throw new UnsupportedOperationException();
        }
        return sb.toString();
    }

    public Object visitListExpressionOperation(ListExpression.Operation operation, Object left, List<Object> right) throws ExpressionVisitException {
        throw new UnsupportedOperationException();
    }

    public Object visitLiteralExpression(LiteralExpression literalExpression) throws ExpressionVisitException {
        if (!(Objects.equals(LiteralExpression.Type.BOOLEAN, literalExpression.getType()) || Objects.equals(LiteralExpression.Type.DATE, literalExpression.getType()) || Objects.equals(LiteralExpression.Type.DATE_TIME, literalExpression.getType()) || Objects.equals(LiteralExpression.Type.STRING, literalExpression.getType()))) {
            throw new UnsupportedOperationException();
        }
        if (Objects.equals(LiteralExpression.Type.BOOLEAN, literalExpression.getType())) {
            return GetterUtil.getBoolean((String)literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.STRING, literalExpression.getType())) {
            return StringUtil.replace((String)literalExpression.getText(), (String)"''", (String)"'");
        }
        return literalExpression.getText();
    }

    public Object visitMemberExpression(MemberExpression memberExpression) throws ExpressionVisitException {
        Expression expression = memberExpression.getExpression();
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitMethodExpression(List<Object> expressions, MethodExpression.Type type) throws ExpressionVisitException {
        throw new UnsupportedOperationException();
    }

    public Object visitPrimitivePropertyExpression(PrimitivePropertyExpression primitivePropertyExpression) throws ExpressionVisitException {
        return primitivePropertyExpression.getName();
    }

    private void _buildBinaryOperation(Object left, String operator, Object right, StringBuilder sb) {
        sb.append(JSONUtil.put((String)left.toString(), (Object)JSONUtil.put((String)operator, (Object)right.toString())));
    }

    private void _buildBinaryOperationAndOr(Object left, String operator, Object right, StringBuilder sb) {
        block3: {
            try {
                JSONObject leftJSONObject = JSONFactoryUtil.createJSONObject((String)((String)left));
                JSONArray jsonArray = leftJSONObject.getJSONArray(operator);
                if (jsonArray == null) {
                    jsonArray = JSONUtil.put((Object)leftJSONObject);
                }
                jsonArray.put(JSONFactoryUtil.createJSONObject((String)((String)right)));
                sb.append(JSONUtil.put((String)operator, (Object)jsonArray));
            }
            catch (JSONException jsonException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)jsonException);
            }
        }
    }
}

