/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.storage.salesforce.internal.rest.manager.v1_0;

import com.liferay.account.constants.AccountConstants;
import com.liferay.account.model.AccountEntryModel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.filter.factory.FilterFactory;
import com.liferay.object.rest.manager.exception.ObjectEntryManagerHttpException;
import com.liferay.object.rest.manager.http.BaseObjectEntryManagerHttp;
import com.liferay.object.rest.manager.http.ObjectEntryManagerHttp;
import com.liferay.object.rest.manager.v1_0.BaseObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.storage.salesforce.configuration.SalesforceConfiguration;
import com.liferay.object.storage.salesforce.internal.web.cache.SalesforceAccessTokenWebCacheItem;
import com.liferay.petra.function.UnsafeTriConsumer;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.entry.manager.storage.type=salesforce"}, service={ObjectEntryManager.class})
public class SalesforceObjectEntryManagerImpl
extends BaseObjectEntryManager
implements ObjectEntryManager {
    private static final String _CUSTOM_OBJECT_SUFFIX = "__c";
    private static final Log _log = LogFactoryUtil.getLog(SalesforceObjectEntryManagerImpl.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private final Map<String, String> _defaultObjectFieldNamesToJSONObjectKeys = HashMapBuilder.put((Object)"createDate", (Object)"CreatedDate").put((Object)"creator", (Object)"OwnerId").put((Object)"externalReferenceCode", (Object)"Id").put((Object)"id", (Object)"Id").put((Object)"modifiedDate", (Object)"LastModifiedDate").put((Object)"userName", (Object)"OwnerId").build();
    @Reference(target="(filter.factory.key=salesforce)")
    private FilterFactory<String> _filterFactory;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    private final ObjectEntryManagerHttp _objectEntryManagerHttp = new BaseObjectEntryManagerHttp(){

        public JSONObject getAccessToken(long companyId, long groupId) {
            for (int retry = 0; retry < 3; ++retry) {
                JSONObject jSONObject = SalesforceAccessTokenWebCacheItem.get(this._getSalesforceConfiguration(companyId, groupId));
                if (jSONObject != null) {
                    return jSONObject;
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)interruptedException);
                }
            }
            throw new ObjectEntryManagerHttpException("Unable to authenticate with Salesforce");
        }

        public String getBaseURL(long companyId, long groupId) {
            JSONObject jsonObject = this.getAccessToken(companyId, groupId);
            return jsonObject.getString("instance_url") + "/services/data/v54.0";
        }

        private SalesforceConfiguration _getSalesforceConfiguration(long companyId, long groupId) {
            try {
                if (groupId == 0L) {
                    return (SalesforceConfiguration)SalesforceObjectEntryManagerImpl.this._configurationProvider.getCompanyConfiguration(SalesforceConfiguration.class, companyId);
                }
                return (SalesforceConfiguration)SalesforceObjectEntryManagerImpl.this._configurationProvider.getGroupConfiguration(SalesforceConfiguration.class, companyId, groupId);
            }
            catch (ConfigurationException configurationException) {
                return (SalesforceConfiguration)ReflectionUtil.throwException((Throwable)configurationException);
            }
        }
    };
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;

    public ObjectEntry addObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectEntry objectEntry, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("ADD_OBJECT_ENTRY", objectDefinition, scopeKey, dtoConverterContext.getUser());
        JSONObject responseJSONObject = this._objectEntryManagerHttp.post(objectDefinition.getCompanyId(), this.getGroupId(objectDefinition, scopeKey), "sobjects/" + objectDefinition.getExternalReferenceCode(), this.toJSONObject(dtoConverterContext, objectDefinition, objectEntry, this._getUnsafeTriConsumer(objectDefinition)));
        return this.getObjectEntry(objectDefinition.getCompanyId(), dtoConverterContext, responseJSONObject.getString("id"), objectDefinition, scopeKey);
    }

    public void deleteObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("DELETE", objectDefinition, scopeKey, dtoConverterContext.getUser());
        this._objectEntryManagerHttp.delete(companyId, this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{"sobjects/", objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode}));
    }

    public Page<ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, Aggregation aggregation, DTOConverterContext dtoConverterContext, String filterString, Pagination pagination, String search, Sort[] sorts) throws Exception {
        this.checkPortletResourcePermission("VIEW", objectDefinition, scopeKey, dtoConverterContext.getUser());
        return this._getObjectEntries(companyId, objectDefinition, scopeKey, dtoConverterContext, pagination, filterString, search, sorts);
    }

    public ObjectEntry getObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("VIEW", objectDefinition, scopeKey, dtoConverterContext.getUser());
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        return this.toObjectEntry(companyId, this._getDateFormat(), this._defaultObjectFieldNamesToJSONObjectKeys, dtoConverterContext, this._objectEntryManagerHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{"sobjects/", objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode})), objectDefinition);
    }

    public String getStorageLabel(Locale locale) {
        return this.language.get(locale, "salesforce");
    }

    public String getStorageType() {
        return "salesforce";
    }

    public ObjectEntry updateObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, ObjectEntry objectEntry, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("UPDATE", objectDefinition, scopeKey, dtoConverterContext.getUser());
        this._objectEntryManagerHttp.patch(companyId, this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{"sobjects/", objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode}), this.toJSONObject(dtoConverterContext, objectDefinition, objectEntry, this._getUnsafeTriConsumer(objectDefinition)));
        return this.getObjectEntry(companyId, dtoConverterContext, externalReferenceCode, objectDefinition, scopeKey);
    }

    private String _getAccountRestrictionSOSQLString(long companyId, DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        if (!this._inlineSQLHelper.isEnabled(companyId, this.getGroupId(objectDefinition, scopeKey)) || !objectDefinition.isAccountEntryRestricted()) {
            return "";
        }
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId());
        return StringBundler.concat((String[])new String[]{objectField.getExternalReferenceCode(), " IN ('", StringUtil.merge((Collection)TransformUtil.transform((Collection)this._accountEntryLocalService.getUserAccountEntries(dtoConverterContext.getUserId(), Long.valueOf(0L), null, AccountConstants.ACCOUNT_ENTRY_TYPES_DEFAULT_ALLOWED_TYPES, Integer.valueOf(0), -1, -1), AccountEntryModel::getExternalReferenceCode), (String)"', '"), "')"});
    }

    private DateFormat _getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    private String _getLocation(ObjectDefinition objectDefinition, Pagination pagination, String predicateString, String search, Sort[] sorts) {
        if (Validator.isNotNull((String)search)) {
            return HttpComponentsUtil.addParameter((String)"search", (String)"q", (String)StringBundler.concat((String[])new String[]{"FIND {`", search, "`} IN ALL FIELDS RETURNING ", objectDefinition.getExternalReferenceCode(), "(FIELDS(ALL)", predicateString, this._getSorts(objectDefinition.getObjectDefinitionId(), sorts), this._getSalesforcePagination(pagination), ")"}));
        }
        return HttpComponentsUtil.addParameter((String)"query", (String)"q", (String)StringBundler.concat((String[])new String[]{"SELECT FIELDS(ALL) FROM ", objectDefinition.getExternalReferenceCode(), predicateString, this._getSorts(objectDefinition.getObjectDefinitionId(), sorts), this._getSalesforcePagination(pagination)}));
    }

    private Page<ObjectEntry> _getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, DTOConverterContext dtoConverterContext, Pagination pagination, String filterString, String search, Sort[] sorts) throws Exception {
        JSONObject responseJSONObject = this._objectEntryManagerHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), this._getLocation(objectDefinition, pagination, this._getSOSQLString(companyId, dtoConverterContext, objectDefinition, filterString, scopeKey), search, sorts));
        if (responseJSONObject == null || responseJSONObject.length() == 0) {
            return Page.of(Collections.emptyList());
        }
        JSONArray jsonArray = Validator.isNotNull((String)search) ? responseJSONObject.getJSONArray("searchRecords") : responseJSONObject.getJSONArray("records");
        return Page.of((Collection)this.toObjectEntries(companyId, this._getDateFormat(), this._defaultObjectFieldNamesToJSONObjectKeys, dtoConverterContext, jsonArray, objectDefinition), (Pagination)pagination, (long)this._getTotalCount(companyId, objectDefinition, this._getSOSQLString(companyId, dtoConverterContext, objectDefinition, filterString, scopeKey), scopeKey, search));
    }

    private String _getSalesforcePagination(Pagination pagination) {
        return StringBundler.concat((Object[])new Object[]{" LIMIT ", pagination.getPageSize(), " OFFSET ", pagination.getStartPosition()});
    }

    private String _getSorts(long objectDefinitionId, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return "";
        }
        StringBundler sb = new StringBundler();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinitionId);
        for (Sort sort : sorts) {
            String fieldName = sort.getFieldName();
            if (fieldName.startsWith("nestedFieldArray.")) {
                String[] parts = StringUtil.split((String)sort.getFieldName(), (String)"#");
                fieldName = parts[1];
            }
            if (Objects.equals(fieldName, "status")) continue;
            if (sb.length() == 0) {
                sb.append(" ORDER BY ");
            } else {
                sb.append(", ");
            }
            String defaultFieldName = this._defaultObjectFieldNamesToJSONObjectKeys.get(fieldName);
            if (defaultFieldName != null) {
                sb.append(defaultFieldName);
            } else {
                ObjectField objectField = this.fetchObjectFieldByName(fieldName, objectFields);
                if (objectField == null) continue;
                sb.append(objectField.getExternalReferenceCode());
            }
            if (!sort.isReverse()) continue;
            sb.append(" DESC");
        }
        return sb.toString();
    }

    private String _getSOSQLString(long companyId, DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, String filterString, String scopeKey) throws Exception {
        String accountRestrictionSOSQLString = this._getAccountRestrictionSOSQLString(companyId, dtoConverterContext, objectDefinition, scopeKey);
        String filterSOSQLString = (String)this._filterFactory.create(filterString, objectDefinition);
        Object sosqlString = "";
        if (Validator.isNull((String)accountRestrictionSOSQLString) && Validator.isNotNull((String)filterSOSQLString)) {
            sosqlString = " WHERE " + filterSOSQLString;
        } else if (Validator.isNotNull((String)accountRestrictionSOSQLString) && Validator.isNull((String)filterSOSQLString)) {
            sosqlString = " WHERE " + accountRestrictionSOSQLString;
        } else if (Validator.isNotNull((String)accountRestrictionSOSQLString) && Validator.isNotNull((String)filterSOSQLString)) {
            sosqlString = StringBundler.concat((String[])new String[]{" WHERE (", filterSOSQLString, ") AND ", accountRestrictionSOSQLString});
        }
        return sosqlString;
    }

    private int _getTotalCount(long companyId, ObjectDefinition objectDefinition, String predicateString, String scopeKey, String search) throws Exception {
        if (Validator.isNotNull((String)search)) {
            JSONObject responseJSONObject = this._objectEntryManagerHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), this._getLocation(objectDefinition, Pagination.of((int)1, (int)200), predicateString, search, null));
            JSONArray jsonArray = responseJSONObject.getJSONArray("searchRecords");
            return jsonArray.length();
        }
        JSONObject responseJSONObject = this._objectEntryManagerHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), HttpComponentsUtil.addParameter((String)"query", (String)"q", (String)StringBundler.concat((String[])new String[]{"SELECT COUNT(Id) FROM ", objectDefinition.getExternalReferenceCode(), predicateString})));
        JSONArray jsonArray = responseJSONObject.getJSONArray("records");
        return jsonArray.getJSONObject(0).getInt("expr0");
    }

    private UnsafeTriConsumer<Map<String, Object>, Object, ObjectField, Exception> _getUnsafeTriConsumer(ObjectDefinition objectDefinition) {
        return (map, value, objectField) -> {
            if (StringUtil.endsWith((String)objectDefinition.getExternalReferenceCode(), (String)_CUSTOM_OBJECT_SUFFIX) && Objects.equals(objectField.getObjectFieldId(), objectDefinition.getTitleObjectFieldId())) {
                map.put("Name", value);
            }
        };
    }
}

